 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kset.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kset_get_args
| 
|       Purpose: Gets command line args for kset
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kset
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kset_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kset is out of sync with arguments specified in kset's *.pane file; please rerun ghostwriter on kset.";


	/*
	 * allocate the kset structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_string(pane, "tb",
			  &(clui_info->tb_string),
			  &(clui_info->tb_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "oname",
			  &(clui_info->oname_string),
			  &(clui_info->oname_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "force",
			  &(clui_info->force_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "author",
			  &(clui_info->author_string),
			  &(clui_info->author_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "email",
			  &(clui_info->email_string),
			  &(clui_info->email_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "icon",
			  &(clui_info->icon_string),
			  &(clui_info->icon_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "misc",
			  &(clui_info->misc_file),
			  &(clui_info->misc_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "addkeyword",
			  &(clui_info->addkeyword_string),
			  &(clui_info->addkeyword_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "rmkeyword",
			  &(clui_info->rmkeyword_string),
			  &(clui_info->rmkeyword_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "description",
			  &(clui_info->description_string),
			  &(clui_info->description_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "category",
			  &(clui_info->category_string),
			  &(clui_info->category_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "subcategory",
			  &(clui_info->subcategory_string),
			  &(clui_info->subcategory_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "version",
			  &(clui_info->version_string),
			  &(clui_info->version_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "atb",
			  &(clui_info->atb_string),
			  &(clui_info->atb_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "aoname",
			  &(clui_info->aoname_string),
			  &(clui_info->aoname_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "aargs",
			  &(clui_info->aargs_string),
			  &(clui_info->aargs_flag))))
	{
	    kerror(NULL, "kset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



