 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kman
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kman.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Displays and prints man pages for software objects
|
|       Purpose: main program for kman
|
|         Input:
|		char *clui_info->tb_string; {toolbox in which to search for the manpage}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->k_string; {keyword to search the whatis file for}
|		int   clui_info->k_flag; {TRUE if -k specified}
|
|		char *clui_info->f_string; {roff formater command for printing man pages}
|		int   clui_info->f_flag; {TRUE if -f specified}
|
|		int clui_info->r_flag; {TRUE if -r specified}
|
|		Optional M.E. group:
|		    int clui_info->man_flag; {TRUE if -man specified}
|
|		    int clui_info->hlp_flag; {TRUE if -hlp specified}
|
|		    int clui_info->manual_flag; {TRUE if -manual specified}
|
|        Output:
|       Returns:
|
|    Written By: Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	char    **toolboxes, **manpages = NULL;
	int     tb_num, manpage_num = 0, mode = MAN;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "BOOTSTRAP");
	kexit_handler(kman_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "BOOTSTRAP", "kman",
		kman_usage_additions);

	/*
	 * Do not do a check args so that kman can be used like man,
	 * i.e. kman kcp no -option need be given.
	 */
	kman_get_args(pane);
	kvf_destroy_form(pane);
	/*
	 * Need to grab multiple -k paramaters from the command line.
	 */
        if (!clui_info->k_flag)
        {
           manpages    = kprog_get_argv();
           manpage_num = kprog_get_argc() - 1;
           if (manpage_num == 0)
           {
              kman_usage_additions();
              kexit(KEXIT_FAILURE);
           }
           manpages = &manpages[1];
        }
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if (clui_info->tb_string != NULL)
        {
           toolboxes = (char **) karray_add(NULL, clui_info->tb_string, 0);
           tb_num = 1;
        }
        else if ((toolboxes = kcms_query_toolboxes(&tb_num)) == NULL)
        {
           kinfo(KSTANDARD, "Warning: No toolboxes accessable in which to \
search for man pages");
           kexit(KEXIT_FAILURE);
        }

	if (clui_info->man_flag)
	   mode = MAN;
	else if (clui_info->hlp_flag)
	   mode = HELP;
	else if (clui_info->manual_flag)
	   mode = MANUAL;
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!clui_info->k_flag)
	   run_kman(manpages, manpage_num, toolboxes, tb_num, mode);
	else
	   run_kwhatis(clui_info->k_string, toolboxes, tb_num);
/* -main_library_call_end */

/* -main_after_lib_call */
        kfree(toolboxes);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kman_usage_additions
| 
|       Purpose: Prints usage additions in kman_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kman
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kman_usage_additions(void)
{
	kfprintf(kstderr, "\tDisplays and prints man pages for software objects\n");

/* -usage_additions */
	kfprintf(kstderr, "\n");
	kfprintf(kstderr, "\t[any Khoros program or library calls]\n");
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kman_free_args
| 
|       Purpose: Frees CLUI struct allocated in kman_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kman
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kman_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->k_string);
	kfree(clui_info->f_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
