 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kexec.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kexec_get_args
| 
|       Purpose: Gets command line args for kexec
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kexec
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kexec_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kexec is out of sync with arguments specified in kexec's *.pane file; please rerun ghostwriter on kexec.";


	/*
	 * allocate the kexec structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_string(pane, "cmd",
			  &(clui_info->cmd_string),
			  &(clui_info->cmd_flag))))
	{
	    kerror(NULL, "kexec_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "args",
			  &(clui_info->args_string),
			  &(clui_info->args_flag))))
	{
	    kerror(NULL, "kexec_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "m",
			  &(clui_info->m_string),
			  &(clui_info->m_flag))))
	{
	    kerror(NULL, "kexec_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "tb",
			  &(clui_info->tb_string),
			  &(clui_info->tb_flag))))
	{
	    kerror(NULL, "kexec_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "oname",
			  &(clui_info->oname_string),
			  &(clui_info->oname_flag))))
	{
	    kerror(NULL, "kexec_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



