 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kexec
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kexec.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Execute a process
|
|       Purpose: main program for kexec
|
|         Input:
|		char *clui_info->cmd_string; {command to be executed}
|		int   clui_info->cmd_flag; {TRUE if -cmd specified}
|
|		char *clui_info->args_string; {command arguments}
|		int   clui_info->args_flag; {TRUE if -args specified}
|
|		char *clui_info->m_string; {machine}
|		int   clui_info->m_flag; {TRUE if -m specified}
|
|		M.I. group:
|		    char *clui_info->tb_string; {toolbox to execute object from}
|		    int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		    char *clui_info->oname_string; {Program Object Name to be executed}
|		    int   clui_info->oname_flag; {TRUE if -oname specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	int     progtype = NONE, showgui = FALSE;
	char  *temp, *tbname, *oname, *arguments, command[KLENGTH],
	      *args[200], leftover[KLENGTH], *path = NULL, *wksp_path = NULL;
	kobject toolbox = NULL, program = NULL, paneobj = NULL, fileobj = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "BOOTSTRAP");
	kexit_handler(kexec_free_args, NULL);

/* -main_get_args_call */
        /*
         *  deliberately leave out call to kclui_check_args,
         *  as xvrun will be called with extra arguments that are
         *  meant for the program that xvrun is to execute.
         */
        pane = kgen_initialize(PANEPATH, KGEN_NONE, "BOOTSTRAP", "kexec",
                               kexec_usage_additions);
	kexec_get_args(pane);
        kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if (!clui_info->tb_flag && !clui_info->oname_flag)
	{
	   ktoolbox_file_initialize();
	   command[0] = '\0';
	   if (clui_info->cmd_string != NULL)
	      kstrcat(command, clui_info->cmd_string);

	   if (clui_info->args_string != NULL)
	   {
	      kstrcat(command, " ");
	      kstrcat(command, clui_info->args_string);
	   }
	   (void) kclui_arguments(leftover);
	   kstrcat(command, " ");
	   kstrcat(command, leftover);
	}
	else
	{
	   tbname = clui_info->tb_string;
	   oname  = clui_info->oname_string;
	   if ((toolbox = kcms_open_toolbox(tbname)) == NULL ||
	       (program = kcms_open_cmobj(toolbox, oname)) == NULL)
	   {
	      (void) kerror(NULL, "main()", "Cannot open %s '%s'.",
			(!toolbox) ? "toolbox" : "program",
			(!toolbox) ? clui_info->tb_string :
			clui_info->oname_string);
	      kexit(KEXIT_FAILURE);
	   }

	   /*
	    *  Get the pane in order to pass it to pane_command()
	    */
	   kcms_get_attribute(program, KCMS_CMOBJ_PROGTYPE, &progtype);
	   kcms_get_attribute(program, KCMS_CMOBJ_UIS_PANE, &paneobj);
	   kcms_get_attribute(paneobj, KCMS_PATH, &path);
	   arguments = clui_info->args_string;

	   if (kcms_get_attribute(program, KCMS_CMOBJ_WORKSPACE, &fileobj) &&
	       fileobj && kcms_get_attribute(fileobj, KCMS_PATH, &wksp_path) &&
	       wksp_path != NULL)
	   {
	      if (kstrstr(arguments, "-gui") != NULL)
	      {
		 showgui = TRUE;
		 kstring_replace(arguments, "-gui", NULL, arguments);
	      }
	   }

           if (showgui == FALSE && pane_command(tbname, oname, path,
			arguments, command) == FALSE)
	   {
              kexit(KEXIT_FAILURE);
	   }

	   /*
	    *  If this pane object is specialized to be an encapsulated
	    *  workspace object, call runwksp to run the workspace.
	    */
	   if (wksp_path != NULL)
	   {
	      if (arguments != NULL)
	      {
	         ksprintf(command, "runwksp -hidden -wksp %s -args '%s'",
			wksp_path, arguments);
	      }
	      else
	         ksprintf(command, "runwksp -hidden -wksp %s", wksp_path);

	      if (showgui)
	         kstrcat(command, " -showgui");
	   }
	   kcms_close(program); kcms_close(toolbox);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	if ((temp = kmakecommand(clui_info->m_string, NULL, command)) == NULL)
	{
	   kerror(NULL, "main()", "Unable to build command for exec'ing.  The \
command string is '%s'\nand the machine specified is '%s'\n", command,
		(!clui_info->m_string ? "<local>" : clui_info->m_string));
	   kexit(KEXIT_FAILURE);
	}

	kinfo(KVERBOSE,"kexec: '%s'\n", temp);
	kcommand_to_args(temp, args);
	kexecvp(args[0], args);
	kerror(NULL, "main()", "Unable to execute command:\n '%s'", command);
	kexit(KEXIT_FAILURE);
	/* never will get here, but oh well... */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kexec_usage_additions
| 
|       Purpose: Prints usage additions in kexec_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kexec
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kexec_usage_additions(void)
{
	kfprintf(kstderr, "\tExecute a process\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kexec_free_args
| 
|       Purpose: Frees CLUI struct allocated in kexec_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kexec
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kexec_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->cmd_string);
	kfree(clui_info->args_string);
	kfree(clui_info->m_string);
	kfree(clui_info->tb_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
