 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kcp.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kcp_get_args
| 
|       Purpose: Gets command line args for kcp
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcp
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kcp_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kcp is out of sync with arguments specified in kcp's *.pane file; please rerun ghostwriter on kcp.";


	/*
	 * allocate the kcp structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_flag(pane, "force",
			  &(clui_info->force_flag))))
	{
	    kerror(NULL, "kcp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "otb",
			  &(clui_info->otb_string),
			  &(clui_info->otb_flag))))
	{
	    kerror(NULL, "kcp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "ntb",
			  &(clui_info->ntb_string),
			  &(clui_info->ntb_flag))))
	{
	    kerror(NULL, "kcp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "oname",
			  &(clui_info->oname_string),
			  &(clui_info->oname_flag))))
	{
	    kerror(NULL, "kcp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kcp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kcp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



