#!/bin/sh

sed=/usr/bin/sed
if [ ! -x $sed ]; then
	sed=/bin/sed
	if [ ! -x $sed ]; then
		sed=sed
	fi
fi

FindEchoN()
{
        # build a list of potential echos, starting with sh built-in
        echoEnd=""
        elist="echo"
        for dir in `echo $PATH | $sed -e 's/:/ /g'`; do
                [ -x "$dir/echo" ] && elist="$elist $dir/echo"
        done
 
        # work through list, see if one of them groks -n
        for echo in $elist; do
                result=`$echo -n hello`
                if [ "$result" != "-n hello" ]; then
                        echoN="$echo -n"
                        break
                fi
        done
        if [ "$echoN" = "" ]; then
                echoN=echo
                echoEnd="\c"
                result=`$echoN "testing"$echoEnd`
                if [ "$result" != "testing" ]; then
                        unset echoEnd
                fi
        fi
}

echon()
{
        $echoN "$* $echoEnd"
}

FindEchoN

needmach=1
while [ $needmach = 1 ]; do
        needmach=0
        cat <<"	EndMachList"
        What sort of machine are you building Khoros on?

        1.  Sun 3, 4, Sparc (SunOS 4.1.X)
        2.  Sun Sparc (Solaris 2.x)
        3.  Dec Alpha (OSF/1)
        4.  Data General (DGUX)                 (partially ported)
        5.  DEC 3100/5000 (Ultrix)              (partially ported)
        6.  NetBSD                              (not ported)
        7.  HP 9000 (s300, s400, s700, s800)    (partially ported)
        8.  IBM RS/6000 (AIX 3.2)               (partially ported)
        9.  SGI (IRIX 4.0.4 or 5.2)             (partially ported)
        10. Sony (NewOS)                        (not ported)
        11. Interactive 386/486                 (not ported)
        12. Cray (Unicos 8)                     (partially ported)
        13. Convex                              (not ported)
        14. BSDI's BSD/386                      (partially ported)
        15. Linux                               (partially ported)
        16. FreeBSD                             (partially ported)
        17. Paragon (OSF1)                      (partially ported)
        18. CPP-DAP                             (not ported)
        19. Sequent                             (partially ported)
	20. HP Convex Exemplar			(partially ported)

        `q' to QUIT the installation
	EndMachList
        echon  "Enter 1-20 or 'q' to quit: "
        read mach

        if [ "$mach" = "q" -o "$mach" = "Q" ]; then
                echo ""
                echo "Exiting the Khoros installation script.  Bye..."
                echo ""
                exit 0
        fi

        if [ "$mach" = "" -o "$mach" -lt 1 -o "$mach" -gt 20 ]; then
                echo ""
                echo "You entered an invalid machine type, please re-enter"
                echo ""
                needmach=1
        fi
done

case $mach in
 
        1)      defarch="sunos"                         # Sun (SunOS 4.1.X)
                CONFIG_FLAGS="" ;;

        2)      defarch="solaris"                       # Sparc (Solaris 2.1)
                CONFIG_FLAGS="-D_POSIX_SOURCE -DSVR4" ;;

        3)      defarch="osf"                           # DEC Alpha
                CONFIG_FLAGS="" ;;

        4)      defarch="dgux"                          # Data General
                CONFIG_FLAGS="-DSYSV -DDGUX -D_POSIX_SOURCE -ansi" ;;

        5)      defarch="ultrix"                        # DEC 3100/5000
                CONFIG_FLAGS="" ;;

        6)      defarch="netbsd"                        # NetBSD
                CONFIG_FLAGS="" ;;

        7)      defarch="hpux"                          # HP 9000
                CONFIG_FLAGS="-D_POSIX_SOURCE -Aa" ;;

        8)      defarch="aix"                           # IBM RS/6000
                CONFIG_FLAGS="-D_IBMR2 -D_POSIX_SOURCE" ;;

        9)      defarch="irix"                          # SGI 4.0.4 or 5.2
                CONFIG_FLAGS="-D_POSIX_SOURCE" ;;

        10)     defarch="newos"                         # Sony
                CONFIG_FLAGS="" ;;

        11)     defarch="i386"                          # 386/486
                CONFIG_FLAGS="-DSYSV -DISC -DSYSV386" ;;

        12)     defarch="unicos"                        # Cray
                CONFIG_FLAGS="-DSYSV -DUSGISH -D_POSIX_SOURCE" ;;

        13)     defarch="convex"                        # Convex
                CONFIG_FLAGS="-Dconvex" ;;

        14)     defarch="bsdi"                          # BSD/386
                CONFIG_FLAGS="-D_POSIX_SOURCE -DNFS_STDOUT_BUG" ;;

        15)     defarch="linux"                         # Linux
                CONFIG_FLAGS="-D_POSIX_SOURCE" ;;

        16)     defarch="freebsd"                       # FreeBSd 1.1
                CONFIG_FLAGS="-D_POSIX_SOURCE -DNFS_STDOUT_BUG" ;;

        17)     defarch="osf1"                          # Paragon
                CONFIG_FLAGS="-D__OSF1__" ;;

        18)     defarch="dap"                           # CPP-DAP
                CONFIG_FLAGS="" ;;

        19)     defarch=dynix                            # Dynix
                CONFIG_FLAGS="-D_POSIX_SOURCE -DSYSV" ;;

	20)	defarch="exemplar"			# HP Convex Exemplar
		CONFIG_FLAGS="-D_POSIX_SOURCE -D__convex_spp"

esac

needcc=1
while [ $needcc = 1 ]; do
        needcc=0
        echon "Enter C-compiler [cc]: "
        read resp
        if [ "$resp" = "" ]; then
                ccomp=cc
        else
                ccomp="$resp"
        fi

        foundcc=""
        for ccdir in `echo $PATH | $sed -e 's/:/ /g'`; do
            if [ -x "$ccdir/$ccomp" ]; then
               foundcc="$ccdir/$ccomp"
               break
            fi
        done
done

arg1=`echo $ccomp | $sed -e 's/[   ].*//'`
if [ "$arg1" = "gcc" -o "$arg1" = "gcc2" ]; then
        CONFIG_FLAGS="$CONFIG_FLAGS -DGCC_DEF"
fi


make -f Makefile.ini clean 
make CC=$ccomp BOOTSTRAPCFLAGS="$CONFIG_FLAGS" -f Makefile.ini
make -f Makefile.ini Makefile
make install
