 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: This file contains the Platform data
   >>>>		       ordering definitions.
   >>>>
   >>>>    Written By: Jeremy Worley & Mark Young & John Salas
   >>>>
   >>>>          Date: Jul 16, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

/*
 * The Khoros 2.0 machine type description uses a single byte, so that
 * it can be recognized without knowing the format a priori.  The
 * upper three bits are used to encode the word ordering.  The lower 5
 * bits are used to encode the floating point format.  Also, since
 * IEEE has so many variants (which typically differ only by word size
 * chosen for some of the datatypes), we encode variants of IEEE in
 * the floating point format portion of the byte.  The IEEE format
 * refers to the generic 32bit ieee format in which shorts are 2
 * bytes, ints, longs, and floats are 4 bytes and doubles are 8 bytes.
 * If a new format is added that is essentially IEEE, but uses
 * different word sizes or is on a 64bit machine, etc. it is given its
 * own format type.  Note that we are going to try to reserve the mach
 * bytes with odd values for IEEE based machines.  Right now, only the
 * generic 32bit IEEE and the DEC Alpha IEEE variant are specified.
 *
 * NOTE: The VAX is basically little endian, but its floating point
 * values are also reordered on half word boundaries.  We don't
 * consider this a unique word ordering, even though there is a pretty
 * good argument that it should be.  The conversion code in kconvert.c
 * in kutils copes with this peculiarity internally.
 *
 *
 * 	bit  7   6   5   4   3   2   1   0
 *	   +---+---+---+---+---+---+---+---+
 *	   | o | o | o | f | f | f | f | f |
 *	   +---+---+---+---+---+---+---+---+
 *
 *	o = order
 *		0x00               --> unknown
 *		0x01 << 5  (0x200) --> big endian
 *		0x02 << 5  (0x400) --> little endian
 *		...
 *
 *	f = floating point format
 *
 *		0x00	   --> unknown
 *		0x01	   --> ieee
 *		0x02	   --> vax
 *		0x03	   --> alpha ieee
 *		0x04	   --> cray/cyber
 *		... 
 */

#ifndef _machine_kmachine_h_
#define _machine_kmachine_h_

        /*-------------------------------------*
        |       #include 
        ---------------------------------------*/

        /*-------------------------------------*
        |       #defines 
        ---------------------------------------*/

#define KFORMAT_UNKNOWN      0x0
#define KFORMAT_IEEE         0x1
#define KFORMAT_VAX          0x2
#define KFORMAT_IEEE_ALPHA   0x3
#define KFORMAT_CRAY         0x4

#define KORDER_UNKNOWN       0x00
#define KORDER_BIG_ENDIAN    0x20
#define KORDER_LITTLE_ENDIAN 0x40



/*
 *  Defines for raw storage format of the different machine architecture
 *  definitions
 */

/*
 * convenience defines
 */
#define KMACH_UNKNOWN    0x0
 
#define KMACH_I80x86  (KORDER_LITTLE_ENDIAN | KFORMAT_IEEE)
#define KMACH_NS32000 KMACH_I80x86 /* Sequent Balance, etc. */
#define KMACH_MIPSEL  KMACH_I80x86 /* decstation */
#define KMACH_I860    KMACH_I80x86 /* not sure about this one */
 
#define KMACH_SPARC   (KORDER_BIG_ENDIAN | KFORMAT_IEEE) /* sun4, solbourne, */
#define KMACH_IBMRT   KMACH_SPARC 
#define KMACH_RS6000  KMACH_SPARC
#define KMACH_POWERPC KMACH_SPARC
#define KMACH_MC680x0 KMACH_SPARC /* incl. macII, next */
#define KMACH_M88x00  KMACH_SPARC /* incl. luna, dg aviion */
#define KMACH_MIPSEB  KMACH_SPARC /* incl. sgi */
#define KMACH_PARISC  KMACH_SPARC  /* HP9000 */
#define KMACH_CONVEX  KMACH_SPARC
#define KMACH_APOLLO  KMACH_SPARC
 
#define KMACH_ALPHA   (KORDER_LITTLE_ENDIAN | KFORMAT_IEEE_ALPHA)

#define KMACH_CYBER   (KORDER_BIG_ENDIAN | KFORMAT_CRAY)
#define KMACH_CRAY    KMACH_CYBER

#define KMACH_VAX     (KORDER_LITTLE_ENDIAN | KFORMAT_VAX)
 

                     /* This one for the Dec Alpha */
#if ( defined(__alpha) || defined(alpha) ) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_ALPHA
#endif
                     /* This one for the Vax */
#if ( defined(__vax) || defined(vax) ) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_VAX
#endif
                     /* This one for the Sun Solaris Sparc */
#if ( defined(__sun) || defined(sun) ) && ( !defined(__i386) && !defined(i386) )  && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_SPARC
#endif

		     /* This one for the Sun Solaris i386 */
#if ( defined(__sun) || defined(sun) ) && ( defined(__i386) || defined(i386) ) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_I80x86
#endif

                     /* This one for Sony */
#if (defined(__sony_news) || defined(sony_news)) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_MC680x0
#endif
                     /* This one for Silicon Graphics */ 
#if ( defined(__sgi) || defined(sgi) ) && !defined(KMACH_LOCAL) 
#define KMACH_LOCAL KMACH_MIPSEB	
#endif
                    /* This one for NeXT */
#if (defined(__NeXT) || defined(NeXT)) && !defined(KMACH_LOCAL) 
#define KMACH_LOCAL KMACH_MC680x0
#endif
                    /* This one for MC680x0 */
#if (defined(__mc68000) || defined(mc68000)) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_MC680x0
#endif
                   /* This one is for the ENCORE and SEQUENT */
#if (defined(__ns32000) || defined(ns32000)) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_NS32000
#endif
			 /* This one is for the DECstation 3100's */
#if (defined(MIPSEL) || defined(__MIPSEL__)) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_NS32000
#endif
			 /* This one is for the DECstation 3100's */
#if (defined(MIPSEB) || defined(__MIPSEB__)) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_MIPSEB
#endif
                   /* This works for APOLLO DN10000 */
#if (defined(__apollo) || defined(apollo))  && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_APOLLO
#endif
		/* this works for hp9000s{300,400,700,800} */
#if ( defined(hp9000s300) || defined(__hp9000s300) ) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_PARISC
#endif
		/* this works for hp9000s{300,400,700,800} */
#if ( defined(hp9000s400) || defined(__hp9000s400) ) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_PARISC
#endif
		/* this works for hp9000s{300,400,700,800} */
#if ( defined(hp9000s700) || defined(__hp9000s700)) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_PARISC
#endif
		/* this works for hp9000s{300,400,700,800} */
#if ( defined(hp9000s800) || defined(__hp9000s800)) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_PARISC
#endif
                    /* This works for the cray */
#if (defined(__cray) || defined(cray) || defined(_CRAY)) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_CRAY
#endif
                    /* This works for ibm 6000 */
#if (defined(__ibm) || defined(ibm) || defined(_IBMR2)) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_RS6000
#endif
               /* This works for the Convex */
#if (defined(__convex__) || defined(convex)) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_CONVEX
#endif
               /* This works for the Mac */
#if (defined(__macII) || defined(macII) || defined(__AUX) || defined(AUX)) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_MC680x0
#endif
               /* This works for the Data General */
#if (defined(__DGUX) || defined(DGUX) || defined(__dgux__) || defined(__dgux) || defined(_DGUX) || defined(__DGUX__)) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_M88x00
#endif
               /* This works for the Intel 386/486*/
#if (defined(__i386__) || defined(i386) || defined(__i386)) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_I80x86
#endif
               /* This works for the Luna 88000 */
#if (defined(__luna) || defined(luna)) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_M88x00
#endif
               /* This works for the Motorola 88000 */
#if (defined(__m88k) || defined(m88k)) && !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_M88x00
#endif

              /* This works for the Paragon */
#if defined(__i860)
#define KMACH_LOCAL KMACH_I860
#endif

               /* unknown type */
#if !defined(KMACH_LOCAL)
#define KMACH_LOCAL KMACH_UNKNOWN
#endif
        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
        |       macros
        ---------------------------------------*/

/*
 * these macros return the bits that correspond to the format portion
 * of a machtype byte and the order portion of the machtype byte.
 */
#define KMACH_FORMAT(machtype) (machtype & 0x1f)
#define KMACH_ORDER(machtype)  (machtype & 0xe0)

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/


#endif /* _machine_kmachine_h_ */
/* Don't add after this point */
