 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: This file contains the #includes that
   >>>>		       are required by different architectures
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: May 07, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */
   
#ifndef _machine_cdefs_h_
#define _machine_cdefs_h_


        /*-------------------------------------*
        |       #include 
        ---------------------------------------*/

       /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

#if defined(__STDC__) || defined(__stdc__)
#define KSTDC_DEF 1
#else
#define KSTDC_DEF 0
#endif

#undef  NONE
#define NONE   0
 
#undef  ERROR
#define ERROR -1
 
#undef  FALSE
#define FALSE  0
 
#undef  TRUE
#define TRUE   1
 
/*
 * General Khoros defines
 */
#undef  KLENGTH
#define KLENGTH         1024

                           /* delete ANSI C keywords */
/*
#define const
#define inline
#define signed
#define volatile
 */

#if defined(__cplusplus)
#define START_DECLARATIONS   extern "C" {
#define END_DECLARATIONS     };
#else
#define START_DECLARATIONS
#define END_DECLARATIONS
#endif


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

#if KSTDC_DEF
   typedef void * kaddr;
#else
   typedef char  * kaddr;
#endif
 
typedef char   *kstring;
typedef unsigned char kbool;
typedef signed   char kbyte;
typedef unsigned char kubyte;
typedef struct { float r, i;   }   kcomplex;
typedef struct { double r, i;  }   kdcomplex;
typedef enum   { KEXIT_SUCCESS=0, KEXIT_FAILURE=1  } kexit_status;
 
typedef int           (*kfunc_int)();
typedef unsigned int  (*kfunc_uint)();
typedef long          (*kfunc_long)();
typedef unsigned long (*kfunc_ulong)();
typedef void          (*kfunc_void)();
typedef kaddr         (*kfunc_kaddr)();
typedef float         (*kfunc_float)();
typedef double        (*kfunc_double)();
typedef kcomplex      (*kfunc_complex)();
typedef kdcomplex     (*kfunc_dcomplex)();


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  Some machines like the luna88k do not define errno
 *  if errno is not defined, then we define it
 */
#ifndef errno
extern int errno;
#endif


        /*-------------------------------------*
        |       macros
        ---------------------------------------*/

#if KSTDC_DEF
#define PROTO(s)       s
#define CONCAT(x,y)    x ## y
#define STRINGARG(s)   #s
#else
#define PROTO(s)       ()
#define CONCAT(x,y)    x /**/ y
#define STRINGARG(s)   "s"
#endif

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

#endif /* _machine_cdefs_h_ */
/* Don't add after this point */
