/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Public definitions: database (dbm) keys for kcms
   >>>>
   >>>>    Written By: Steven Jorgensen and Neil Bowers
   >>>>
   >>>>          Date: 
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kcms_keys_h_
#define _kcms_keys_h_


	/*-------------------------------------*
	|       #include
	---------------------------------------*/


	/*-------------------------------------*
	|       #defines
	---------------------------------------*/


/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMS_VERSION
| Description:	Version of kcms which generated the database.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMS_VERSION		"CMS_VERSION"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_MISC_FILES
| Description:	List of miscellaneous files associated with a toolbox
|		or software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_MISC_FILES		"MISC_FILES"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_AUTHOR_EMAIL
| Description:	Email address of author, or point-of-contact,
|		for a toolbox or software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_AUTHOR_EMAIL		"AUTHOR_EMAIL"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_AUTHOR
| Description:	The full name of the author, or point-of-contact, for
|		a toolbox or software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_AUTHOR			"AUTHOR"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_APP_DEFAULTS
| Description:	List of app-defaults files associated with a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_APP_DEFAULTS		"APP_DEFAULTS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_TODO
| Description:	Path to the `todo' info file for a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_TODO_FILE     		"TODO_FILE"
#define KCMS_KEY_TODO			KCMS_KEY_TODO_FILE

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_BUGS
| Description:	Path to the `bugs' info file for a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_BUGS_FILE     		"BUGS_FILE"
#define KCMS_KEY_BUGS			KCMS_KEY_BUGS_FILE

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_DONE
| Description:	Path to the `done' info file for a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_DONE_FILE     		"DONE_FILE"
#define KCMS_KEY_DONE			KCMS_KEY_DONE_FILE

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CHANGELOG
| Description:	Path to the `change log' info file for a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CHANGELOG_FILE		"CHANGELOG_FILE"
#define KCMS_KEY_CHANGELOG		KCMS_KEY_CHANGELOG_FILE

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_STATUS
| Description:	The status of a toolbox.
------------------------------------------------------------------------*/
#define KCMS_KEY_STATUS			"STATUS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_ICON_NAME
| Description:	The `icon name' for a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_ICON_NAME		"ICON_NAME"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_BNAME
| Description:	The binary name of a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_BNAME		"BNAME"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_LANG
| Description:	The programming language used to implement the
|		software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_LANG		"LANG"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_SRCS
| Description:	A list of source files associated with a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_SRCS		"SRCS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_YSRCS
| Description:	A list of Lex source files associated with a
|		software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_YSRCS		"YSRCS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_LSRCS
| Description:	A list of Lex source files associated with a
|		software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_LSRCS		"LSRCS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_FSRCS
| Description:	A list of Fortran source files associated with a
|		software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_FSRCS		"FSRCS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_CPLUSPLUS
| Description:	A list of C++ source files associated with a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_CPLUSPLUS	"C++SRCS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_HEADERS
| Description:	A list of header files (includes) associated with a
|		software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_HEADERS		"HEADERS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_SCRIPTS
| Description:	A list of script files associated with a script object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_SCRIPTS		"SCRIPTS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_IN_CANTATA
| Description:	A flag which specifies whether a software object should
|		appear in cantata.
------------------------------------------------------------------------*/
#define KCMS_KEY_IN_CANTATA		"IN_CANTATA"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_COBJS
| Description:	List of C object files for a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_COBJS		"COBJS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_FOBJS
| Description:	List of Fortran object files for a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_FOBJS		"FOBJS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_LOBJS
| Description:	List of Lex object files for a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_LOBJS		"LOBJS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_YOBJS
| Description:	List of Yacc object files for a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_YOBJS		"YOBJS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_CPLUSOBJS
| Description:	List of C++ object files for a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_CPLUSOBJS	"CPLUSOBJS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_UNSHARED_OBJS
| Description:	List of unshared object files for a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_UNSHARED_OBJS	"UNSHARED_OBJS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CATEGORY
| Description:	The category string for a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CATEGORY		"CATEGORY"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_SUBCATEGORY
| Description:	The subcategory string for a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_SUBCATEGORY		"SUBCATEGORY"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_TYPE
| Description:	The type of a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_TYPE		"PROG_TYPE"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_UIS_PANE
| Description:	The path to the pane UIS file of a kroutine, xvroutine,
|		or script.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_UIS_PANE		"UIS_PANE"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_UIS_FORM
| Description:	The path to the form UIS file of an xvroutine.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_UIS_FORM		"UIS_FORM"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_GHOST_SRC
| Description:	The path to the main source file for a kroutine or xvroutine
|		software object, which contains the code generation tags.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_GHOST_SRC	"GHOST_SRC"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_GHOST_HEADER
| Description:	The path to the include file for a kroutine or xvroutine
|		software object, which contains the code generation tags.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_GHOST_HEADER	"GHOST_HEADER"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_GHOST_LIB
| Description:	The name of the library which contains an associated
|		library function for a kroutine software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_GHOST_LIB	"GHOST_LIB"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_GHOST_MAN1
| Description:	The path to the man page for a kroutine, xvroutine,
|		pane, or script object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_GHOST_MAN1	"GHOST_MAN1"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_GHOST_MAN3
| Description:	The path to the library man page associated with
|		a kroutine software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_GHOST_MAN3	"GHOST_MAN3"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_GHOST_HELP
| Description:	The path to the help file for a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_GHOST_HELP	"GHOST_HELP"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_GHOST_SCRIPT
| Description:	The path to the generate script for a pane object.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_GHOST_SCRIPT	"GHOST_SCRIPT"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_COND_LEVELS
| Description:	Extraction levels to use when generating GUI code.
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_COND_LEVELS	"COND_LEVELS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CMOBJ_STATE_CTYPE
| Description:	Type of C used -- K&R or ANSI?
------------------------------------------------------------------------*/
#define KCMS_KEY_CMOBJ_STATE_CTYPE	"STATE_CTYPE"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_GENERATE_EXECUTABLE
| Description:	Should an executable be generated for a pane object.
------------------------------------------------------------------------*/
#define KCMS_KEY_GENERATE_EXECUTABLE	"GENERATE_EXECUTABLE"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_WORKSPACE
| Description:	The path to the workspace file associated with a pane object.
------------------------------------------------------------------------*/
#define KCMS_KEY_WORKSPACE		"WORKSPACE"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_UIS_MISC
| Description:	A list of miscellaneous UIS files associated with
|		a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_UIS_MISC		"UIS_MISC"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_TB_SOFTWARE_OBJECTS
| Description:	The list of software objects contained within a toolbox.
------------------------------------------------------------------------*/
#define KCMS_KEY_TB_SOFTWARE_OBJECTS	"SOFTWARE_OBJECTS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_TB_NAME
| Description:	The name of a toolbox.
------------------------------------------------------------------------*/
#define KCMS_KEY_TB_NAME		"TB_NAME"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_TITLE
| Description:	The title string for a toolbox.
------------------------------------------------------------------------*/
#define KCMS_KEY_TITLE			"TITLE"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_SHORT_DESCRIPTION
| Description:	The short description of a software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_SHORT_DESCRIPTION	"SHORT_DESCRIPTION"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_INFO_FILE
| Description:	Path to the toolbox `info', or description, file.
------------------------------------------------------------------------*/
#define KCMS_KEY_INFO_FILE		"INFO_FILE"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_CONFIG_FILE
| Description:	Path to the imake configuration file for a toolbox.
------------------------------------------------------------------------*/
#define KCMS_KEY_CONFIG_FILE		"CONFIG_FILE"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_INCLUDE_FILE
| Description:	Path to the toolbox include file.
------------------------------------------------------------------------*/
#define KCMS_KEY_INCLUDE_FILE		"INCLUDE_FILE"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_ALIAS_FILE
| Description:	Path to the Aliases file for a toolbox.
------------------------------------------------------------------------*/
#define KCMS_KEY_ALIAS_FILE		"ALIAS_FILE"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_SHORT_COPYRIGHT
| Description:	The `short' copyright statement associated with a toolbox.
------------------------------------------------------------------------*/
#define KCMS_KEY_SHORT_COPYRIGHT	"SHORT_COPYRIGHT"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_LONG_COPYRIGHT
| Description:	The `long' copyright statement associated with a toolbox.
------------------------------------------------------------------------*/
#define KCMS_KEY_LONG_COPYRIGHT		"LONG_COPYRIGHT"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_KEYWORDS
| Description:	List of keywords associated with toolbox or software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_KEYWORDS		"KEYWORDS"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_DATES
| Description:	The three date strings associated with the object, in the
|		order: creation, modification, generation (by the code
|		generators)
------------------------------------------------------------------------*/
#define KCMS_KEY_DATES			"DATES"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_VERSION
| Description:	Version of the toolbox or software object.
------------------------------------------------------------------------*/
#define KCMS_KEY_VERSION		"VERSION"

/*------------------------------------------------------------------------
| Key:		KCMS_KEY_ASSOCIATED_OBJECT
| Description:	A software object which is associated with this object.
|		Currently used to store the kroutine invoked by a pane
|		object.  Stored as "toolbox:object".
------------------------------------------------------------------------*/
#define KCMS_KEY_ASSOCIATED_OBJECT	"ASSOCIATED_OBJECT"

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/


#endif /* _kcms_keys_h_ */
/* Don't add after this point */
