/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Contains #defines and routine declarations used
   >>>>		       by the ghost library, the ghostreader
   >>>>		       and ghostwriter programs.
   >>>>
   >>>>    Written By: Danielle Argiro
   >>>>
   >>>>          Date: Jul 13, 1992 10:27
   >>>>
   >>>> Modifications: Converted from ghost.h in Khoros 1.0 (DA)
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kcms_ghost_h_
#define _kcms_ghost_h_

	/*-------------------------------------*
        |       #include
        ---------------------------------------*/

	/*-------------------------------------*
        |       #defines
        ---------------------------------------*/

#define MAX_NAME_LENGTH		9
#define MAX_ME_GROUPNUM		50
#define MAX_TOGGLENUM		75
#define MAX_PROGSPEC_SIZE	37
#define MAX_LINELENGTH		80
#define MAX_TEXTBLOCK		200
#define MAX_CMDLINE_ARGS	200

#define LONG_CPRIGHT   1
#define SHORT_CPRIGHT  2
#define SCRIPT_CPRIGHT  3


	/* #defines for prog spec array */

#define AUTHORS			0	/* -authors                */

#define MAN1_LONGDESC		1       /* -man1_long_description  */
#define MAN1_EXAMPLES		2	/* -man1_examples          */
#define MAN1_RESTRICTIONS	3	/* -man1_restrictions      */
#define MAN1_REFERENCES		4	/* references              */
#define MAN1_SEEALSO		5	/* -man1_see_also          */

#define USAGEADD		6	/* -usage_additions        */

#define INCLUDE_INCLUDES	7	/* -include_includes       */
#define INCLUDE_DEFINES	        8	/* -include_defines        */
#define INCLUDE_TYPEDEFS        9	/* -include_typedefs       */
#define INCLUDE_VARIABLES       10	/* -include_variables      */
#define INCLUDE_MACROS		11	/* -include_macros         */
#define INCLUDE_ROUTINES	12	/* -include_routines       */
#define INCLUDE_ADDITIONS	13	/* -include_additions      */

#define MAIN_VARIABLES		14	/* -main_variable_list     */
#define MAIN_GETARGS		15	/* -main_get_args_call     */
#define MAIN_BEFORELIB		16	/* -main_before_lib_call   */
#define MAIN_LIBCALL		17	/* -main_library_call      */
#define MAIN_AFTERLIB		18	/* -main_after_lib_call    */

#define FREEHANDADD		19	/* -free_handler_additions */

#define LIBRARY_SHORTDESC	20	/* short lib description   */
#define LIBRARY_LONGDESC	21	/* long lib description    */
#define LIBRARY_INPUT		22      /* -library_input          */
#define LIBRARY_OUTPUT		23      /* -library_output         */
#define LIBRARY_RETURNS		24      /* -library_returns        */
#define LIBRARY_RESTRICT	25      /* -library_restrictions   */
#define LIBRARY_VERIFY		26      /* -library_verify         */
#define LIBRARY_SIDEEFF		27      /* -library_sideeffects    */
#define LIBRARY_MODS		28	/* -library_mods           */
#define LIBRARY_DEF		29	/* -library_def            */
#define LIBRARY_CODE		30	/* -library_code           */
#define LIBRARY_INCLUDES	31	/* -library_includes       */

#define MAN3_SHORTDESC          32      /* -man3_shortdesc         */
#define MAN3_LONGDESC           33      /* -man3_longdesc          */
#define MAN3_ADDINFO            34      /* -man3_addinfo           */
#define MAN3_SEEALSO            35      /* -man3_seealso           */
#define MAN3_MANUAL             36      /* -man3_manual            */

	/* #defines for a toolbox log file */

#define VersionNum		0
#define AuthorsList		1
#define RevisionLog		2
#define LibPath			3
#define BinPath			4
#define LibSearch		5
#define IncSearch		6
#define CompDef			7
#define ToolLibs		8
#define XLibs			9
#define ForLibs			10

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

char *kghost_get_copyright	PROTO((char *, int));

	/*
	 *  general utilities to generate standardized 
	 *  copyrights, headers, etc.
	 */
void kgen_rcs_chdr              PROTO((kfile *));
void kgen_rcs_hhdr              PROTO((kfile *));
void kgen_rcs_shhdr             PROTO((kfile *));
void kgen_inclfile_hdr          PROTO((kfile *, char *, char *, char *));
void kgen_inclfile_incl_comm    PROTO((kfile *));
void kgen_inclfile_def_comm     PROTO((kfile *));
void kgen_inclfile_typedef_comm PROTO((kfile *));
void kgen_inclfile_global_comm  PROTO((kfile *));
void kgen_inclfile_macro_comm   PROTO((kfile *));
void kgen_inclfile_routine_comm PROTO((kfile *));
void kgen_pubsrc_hdr            PROTO((kfile *, char *, char *, char *, char *, char *, char *, char *, char *, char *, char *));
void kgen_privsrc_hdr           PROTO((kfile *, char *, char *, char *, char *, char *, char *));
void kgen_scriptsrc_hdr         PROTO((kfile *, char *, char *, char *, char *, char *));
void kgen_srcfile_hdr           PROTO((kfile *, char *, char **, int, char **, int, char **, int));


	/*
	 * These routine chould be static, but I don't have get attribute
	 * garabage finished.. Remove this and go throught get_attributes
	 * in the future.
	 */
char *kghost_get_after_gui_loop		PROTO((kfile *));
char *kghost_get_before_gui_loop	PROTO((kfile *));
char *kghost_get_before_form		PROTO((kfile *));
char *kghost_get_run_vars		PROTO((kfile *));


#endif /* _kcms_ghost_h_ */
/* Don't add after this point*/
