 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for dispimage
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "dispimage.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - simple image display example
|
|       Purpose: main program for dispimage
|
|         Input:
|		char *clui_info->i_file; {First Input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Mar 30, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{
	xvobject parent, object = NULL;  /* ADDED */

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DIP");
	kexit_handler(dispimage_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DIP", "dispimage",
		dispimage_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	dispimage_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

/* -main_before_lib_call */

	/*
	 * sanity check: need input file
	 */
	if ((!clui_info->i_flag) || (clui_info->i_file == NULL))
	   return;

	/*
	 *  create parent object
	 */

	parent = xvw_create_manager(NULL, "dispimage");
        object = xvw_create_image(parent, "image");
        xvw_set_attributes(object,
		XVW_IMAGE_IMAGEFILE,    clui_info->i_file,
		NULL);
	xvw_add_action(object, "<Key>q",    quit_dispimage, NULL, TRUE);
	xvw_add_action(object, "<BtnDown>(2)", quit_dispimage, NULL, TRUE);

/* -main_before_lib_call_end */

/* -main_library_call */
	xvf_run_form();
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}

void quit_dispimage(
   xvobject object,
   kaddr    clientData,
   XEvent   *event)
{
        xvw_destroy(object);
        kexit(KEXIT_SUCCESS);
}

/*-----------------------------------------------------------
| 
|  Routine Name: dispimage_usage_additions
| 
|       Purpose: Prints usage additions in dispimage_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname dispimage
|          Date: Mar 30, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void dispimage_usage_additions(void)
{
	kfprintf(kstderr, "\tsimple image display example\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: dispimage_free_args
| 
|       Purpose: Frees CLUI struct allocated in dispimage_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname dispimage
|          Date: Mar 30, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void dispimage_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info == NULL) return;
	kfree(clui_info->i_file);
	kfree(clui_info);

/* -free_handler_additions */
/* -free_handler_additions_end */
}
