#!/bin/csh -f

#
# Khoros: $Id$
#
# $Log$
#

# Copyright (C) 1993, 1994, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

#************************************************************
#
#  Routine Name: kxv - shell script named kxv
#
#       Purpose: XV, image visualization and color editing by J. Bradley
#
#         Input: argument1 - input file
#		 argument2 - output file
#		 viff flag - do an internal convertion to and from PNM
#
#    Written By: R Lotufo
#          Date: 12 November 1994
#
#************************************************************/

set error_flag = 0

set i_flag       = 0
set o_flag       = 0
set viffin_flag  = 0
set viffout_flag = 0

set i_file_flag = 0
set o_file_flag = 0

set i_file =             #default = empty
set o_file =             #default = empty

while ($#argv)
  switch($argv[1])
      case -i:
        set i_flag = 1
        breaksw
      case -o:
        set o_flag = 1
        breaksw
      case -viffin:
        set viffin_flag = 1
        breaksw
      case -viffout:
        set viffout_flag = 1
        breaksw
      case -U:
        goto usage
        breaksw
      case -[A-T]*:	# not valid switches
      case -[V-Z]*;
      case -[a-h]*:
      case -[j-n]*:
      case -[p-z]*:
        set error_flag = 1
        goto usage
        breaksw
      default:
        if ($i_flag) then
                set i_file = $argv[1]
                set i_file_flag = 1
                set i_flag = 0
        else if ($o_flag) then
                set o_file = $argv[1]
                set o_file_flag = 1
                set o_flag = 0
        endif
        breaksw
  endsw
  shift
end

set cp_flag = 0

if ($i_file_flag) then
	if (! (-e $i_file)) then
		/bin/sh -c 'echo "Unable to open file $i_file" |>&2'
      		echo "Unable to open file $i_file"
      		set error_flag = 1
      		goto usage
	endif
endif

#case both input and output
if ($o_file_flag && $i_file_flag  && ($i_file != $o_file)) then
		cp $i_file $o_file
		set cp_info_before = `ls -alF $o_file`
		set cp_flag = 1
endif

#case only input exists
if ($i_file_flag && (! $o_file_flag) ) then
  set aux = `printenv |grep TMPDIR`
  if ( "x$aux" == "x" ) then
    setenv TMPDIR .
  endif

  set o_file = $TMPDIR/kxv$$
  cp $i_file $o_file
  set cp_info_before = `ls -alF $o_file`
  set cp_flag = 1
endif

if ($viffin_flag && $i_file_flag) then
  kformats -i $o_file -o $o_file -pnm
  if ($status) then
        /bin/sh -c 'echo "XV: Error in kformats -pnm" |>&2'
	echo "XV: Error in kformats -pnm"
	set error_flag = 1
   	goto cleanup
  endif
endif

xv -dir `dirname $o_file` `basename $o_file`

if ($viffout_flag && $o_file_flag) then
  kformats -i $o_file -o $o_file -viff
  if ($status) then
        /bin/sh -c 'echo "XV: Error in kformats -viff" |>&2'
	echo "XV: Error in kformats -viff"
	set error_flag = 1
   	goto cleanup
  endif
endif

cleanup:
    if ($cp_flag) then
	set cp_info_after = `ls -alF $o_file`
	if ("$cp_info_after" == "$cp_info_before") then
		\rm $o_file
	endif
    endif

    unset i_flag
    unset o_flag
    unset viffin_flag
    unset viffout_flag

    unset i_file_flag
    unset o_file_flag

    unset i_file
    unset o_file

    unset cp_info_before
    unset cp_info_after
    unset cp_flag

    if ($error_flag) then
        unset error_flag
        exit 1          # an error
    else
        unset error_flag
        exit 0
    endif
usage:
    echo ""
    echo "kxv: XV visualization and color editor, by J. Bradley
    echo ""
    echo "Usage:"
    echo "  [-i]     input file"
    echo "  [-o]     output file"
    echo "  [-viffin ]  convert file from VIFF to PNM before calling xv
    echo "  [-viffout]  convert file from PNM to VIFF after  calling xv
    echo ""
    echo "  [-U]     get this message"
    echo ""
    goto cleanup

