/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: Fimg2viff.h
 >>>>            Author: Donna Koechner
 >>>> Date Last Updated: Sun Mar 10 11:30:00 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _Fimg2viff_h_
#define _Fimg2viff_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    Fimg2viff Argument Structure
*
****************************************************************/

typedef struct _Fimg2viff  {

/*
 *  input raw data file (Required infile)
 */
char	*i_file;	/* input raw data file FILENAME */
int	 i_flag;	/* input raw data file FLAG */

/*
 *  resulting output image (viff file) (Required outfile)
 */
char	*o_file;	/* resulting output image (viff file) FILENAME */
int	 o_flag;	/* resulting output image (viff file) FLAG */

/*
 *  number of rows (Optional integer)
 */
int	 r_int; 	/* number of rows INT */
int	 r_flag;	/* number of rows FLAG */

/*
 *  number of columns (Optional integer)
 */
int	 c_int; 	/* number of columns INT */
int	 c_flag;	/* number of columns FLAG */

/*
 *  number of bytes to offset from the start the input file (Optional integer)
 */
int	 h_int; 	/* number of bytes to offset from the start the input file INT */
int	 h_flag;	/* number of bytes to offset from the start the input file FLAG */

}  Fimg2viff_struct;

Fimg2viff_struct *Fimg2viff;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
