/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: Sraw2viff.h
 >>>>            Author: Donna Koechner
 >>>> Date Last Updated: Mon Apr 15 22:25:12 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _Sraw2viff_h_
#define _Sraw2viff_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    Sraw2viff Argument Structure
*
****************************************************************/

typedef struct _Sraw2viff  {

/*
 *  input signa raw image file (Required infile)
 */
char	*i_file;	/* input signa raw image file FILENAME */
int	 i_flag;	/* input signa raw image file FLAG */

/*
 *  complex output file (VIFF) (Optional outfile)
 */
char	*o1_file;	/* complex output file (VIFF) FILENAME */
int	 o1_flag;	/* complex output file (VIFF) FLAG */

/*
 *  real part output filename (Optional outfile)
 */
char	*o2_file;	/* real part output filename FILENAME */
int	 o2_flag;	/* real part output filename FLAG */

/*
 *  imaginary part output filename (Optional outfile)
 */
char	*o3_file;	/* imaginary part output filename FILENAME */
int	 o3_flag;	/* imaginary part output filename FLAG */

/*
 *  number of rows (Optional integer)
 */
int	 r_int; 	/* number of rows INT */
int	 r_flag;	/* number of rows FLAG */

/*
 *  number of columns (Optional integer)
 */
int	 c_int; 	/* number of columns INT */
int	 c_flag;	/* number of columns FLAG */

/*
 *  byte offset from the start of the input data file (Optional integer)
 */
int	 h_int; 	/* byte offset from the start of the input data file INT */
int	 h_flag;	/* byte offset from the start of the input data file FLAG */

}  Sraw2viff_struct;

Sraw2viff_struct *Sraw2viff;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
