/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vspcomp.c
 >>>>
 >>>>      Program Name: vspcomp
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compensate sputter yield for angular dependence
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:20:09 1991
 >>>>
 >>>>          Routines: main- the main program for vspcomp
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vspcomp.h"


/****************************************************************
 *
 * Routine Name:  main program for vspcomp
 *
 *       Input:  
 *         -y  yield input image 
 *         -ang  input image 
 *         -o  compensated output image 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img1, *img2, *img3, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        img1 = readimage(vspcomp->y_file);
        if (img1 == NULL) exit(1);                    

        img2 = readimage(vspcomp->ang_file);
        if (img2 == NULL) exit(1);                    

        if (img1->data_storage_type != VFF_TYP_FLOAT)
          {
            fprintf(stderr,"vsurf: Surface image must be a FLOAT image\n");
            exit(1);
          }
        if (img2->data_storage_type != VFF_TYP_FLOAT)
          {
            fprintf(stderr,"vspcomp: Angle image must be a FLOAT image\n");
            exit(1);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvspcomp(img1, img2, &img3) )
        {
            (void) fprintf(stderr, "lvspcomp Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        (void) writeimage(vspcomp->o_file, img3);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vspcomp 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vspcomp :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompensate sputter yield for angular dependence\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-y  yield input image  (infile)\n");
	fprintf(stderr,"\t-ang  input image  (infile)\n");
	fprintf(stderr,"\t-o  compensated output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vspcomp\n");
	fprintf(stderr, "\t[-U] Gives the usage for vspcomp\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vspcomp.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vspcomp.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vspcomp
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*y_pstr = 
	"\nEnter: (y) yield input image \n        {infile}: "; 
char	*ang_pstr = 
	"\nEnter: (ang) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) compensated output image \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vspcomp", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vspcomp.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vspcomp: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vspcomp.ans");
		}

	     }

	}

	/*
	 * allocate the vspcomp structure
	 */
	vspcomp = (vspcomp_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vspcomp_struct));

	/*
	 * get required arguments for vspcomp
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vspcomp->y_flag = vget_infile(fid, prompt_flag,
			"-y", y_pstr, &(vspcomp->y_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vspcomp->y_flag))
		{
		    fprintf(stderr, "\t\ty is required, please re-enter: \n");
		    vspcomp->y_flag = vget_infile(fid, prompt_flag,
		    "-y", y_pstr, &(vspcomp->y_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-y' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vspcomp->ang_flag = vget_infile(fid, prompt_flag,
			"-ang", ang_pstr, &(vspcomp->ang_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vspcomp->ang_flag))
		{
		    fprintf(stderr, "\t\tang is required, please re-enter: \n");
		    vspcomp->ang_flag = vget_infile(fid, prompt_flag,
		    "-ang", ang_pstr, &(vspcomp->ang_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-ang' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vspcomp->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vspcomp->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vspcomp->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vspcomp->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vspcomp->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



