/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vasphere.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Tue Apr 23 02:07:16 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vasphere_h_
#define _vasphere_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vasphere Argument Structure
*
****************************************************************/

typedef struct _vasphere  {

/*
 *  output image (Required outfile)
 */
char	*o_file;	/* output image FILENAME */
int	 o_flag;	/* output image FLAG */

/*
 *  desired number of rows in output image (Optional integer)
 */
int	 r_int; 	/* desired number of rows in output image INT */
int	 r_flag;	/* desired number of rows in output image FLAG */

/*
 *  desired number of columns in output image (Optional integer)
 */
int	 c_int; 	/* desired number of columns in output image INT */
int	 c_flag;	/* desired number of columns in output image FLAG */

/*
 *  coordinate system X origin (pixel number) (Optional integer)
 */
int	 cx_int; 	/* coordinate system X origin (pixel number) INT */
int	 cx_flag;	/* coordinate system X origin (pixel number) FLAG */

/*
 *  coordinate system Y origin (pixel number) (Optional integer)
 */
int	 cy_int; 	/* coordinate system Y origin (pixel number) INT */
int	 cy_flag;	/* coordinate system Y origin (pixel number) FLAG */

/*
 *  X offset of center of symmetry (meters) (Optional float)
 */
float	 x_float;	/* X offset of center of symmetry (meters) FLOAT */
int	 x_flag;   	/* X offset of center of symmetry (meters) FLAG */

/*
 *  Y offset of center of symmetry (meters) (Optional float)
 */
float	 y_float;	/* Y offset of center of symmetry (meters) FLOAT */
int	 y_flag;   	/* Y offset of center of symmetry (meters) FLAG */

/*
 *  curvature parameter (Optional float)
 */
float	 curv_float;	/* curvature parameter FLOAT */
int	 curv_flag;   	/* curvature parameter FLAG */

/*
 *  A2 Coefficient (Optional float)
 */
float	 a2_float;	/* A2 Coefficient FLOAT */
int	 a2_flag;   	/* A2 Coefficient FLAG */

/*
 *  A4 Coefficient (Optional float)
 */
float	 a4_float;	/* A4 Coefficient FLOAT */
int	 a4_flag;   	/* A4 Coefficient FLAG */

/*
 *  A6 Coefficient (Optional float)
 */
float	 a6_float;	/* A6 Coefficient FLOAT */
int	 a6_flag;   	/* A6 Coefficient FLAG */

/*
 *  A8 Coefficient (Optional float)
 */
float	 a8_float;	/* A8 Coefficient FLOAT */
int	 a8_flag;   	/* A8 Coefficient FLAG */

/*
 *  A10 Coefficient (Optional float)
 */
float	 a10_float;	/* A10 Coefficient FLOAT */
int	 a10_flag;   	/* A10 Coefficient FLAG */

/*
 *  piston (meters) (Optional float)
 */
float	 piston_float;	/* piston (meters) FLOAT */
int	 piston_flag;   	/* piston (meters) FLAG */

/*
 *  pixel size (meters) (Optional float)
 */
float	 s_float;	/* pixel size (meters) FLOAT */
int	 s_flag;   	/* pixel size (meters) FLAG */

/*
 *  cutoff radius (meters) (Optional float)
 */
float	 cutoff_float;	/* cutoff radius (meters) FLOAT */
int	 cutoff_flag;   	/* cutoff radius (meters) FLAG */

/*
 * Selects data type of output image (Optional string toggle - )
 */
char	*t_toggle;		/* Selects data type of output image STRING TOGGLE */
int	 t_flag;		/* Selects data type of output image FLAG */

}  vasphere_struct;

vasphere_struct *vasphere;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
