/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vpset.c
 >>>>
 >>>>      Program Name: vpset
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Set a pixel in an image to a given value
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Sat Apr 27 10:32:08 1991
 >>>>
 >>>>          Routines: main- the main program for vpset
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vpset.h"


/****************************************************************
 *
 * Routine Name:  main program for vpset
 *
 *       Input:  
 *       -i  input image 
 *       -o  resulting output image 
 *       -x  X coordinate of pixel   (value >= 0)
 *       -y  Y coordinate of pixel   (value >= 0)
 *       -b  band number   (value >= 0)
 *       -v  value to set pixel to  
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *img, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);
    img = readimage(vpset->i_file);
    if (img == NULL) exit(1);
    CHECKINPUT(program,img);
/* -main_before_lib_call_end */

/* -main_library_call */
    if(!lvpset(img,vpset->x_int,vpset->y_int,vpset->b_int,vpset->v_float))
    {
        (void) fprintf(stderr, "lvpset Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vpset->o_file,img);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vpset 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vpset :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tSet a pixel in an image to a given value\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr,"\t-x  X coordinate of pixel  (integer, >= 0)\n");
	fprintf(stderr,"\t-y  Y coordinate of pixel  (integer, >= 0)\n");
	fprintf(stderr,"\t-b  band number  (integer, >= 0)\n");
	fprintf(stderr,"\t-v  value to set pixel to  (float)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vpset\n");
	fprintf(stderr, "\t[-U] Gives the usage for vpset\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vpset.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vpset.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vpset
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*x_pstr = 
	"\nEnter: (x) X coordinate of pixel \n        {integer, >= 0}: "; 
char	*y_pstr = 
	"\nEnter: (y) Y coordinate of pixel \n        {integer, >= 0}: "; 
char	*b_pstr = 
	"\nEnter: (b) band number \n        {integer, >= 0}: "; 
char	*v_pstr = 
	"\nEnter: (v) value to set pixel to \n        {float}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vpset", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vpset.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vpset: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vpset.ans");
		}

	     }

	}

	/*
	 * allocate the vpset structure
	 */
	vpset = (vpset_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vpset_struct));

	/*
	 * get required arguments for vpset
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vpset->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vpset->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpset->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vpset->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vpset->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vpset->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vpset->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpset->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vpset->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vpset->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vpset->x_flag = vget_int(fid, prompt_flag,
			"-x", x_pstr, &(vpset->x_int),
			0, 1, 1)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpset->x_flag))
		{
		    fprintf(stderr, "\t\tx is required, please re-enter: \n");
		    vpset->x_flag = vget_int(fid, prompt_flag,
		    "-x", x_pstr, &(vpset->x_int),
		    0, 1, 1);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-x' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vpset->y_flag = vget_int(fid, prompt_flag,
			"-y", y_pstr, &(vpset->y_int),
			0, 1, 1)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpset->y_flag))
		{
		    fprintf(stderr, "\t\ty is required, please re-enter: \n");
		    vpset->y_flag = vget_int(fid, prompt_flag,
		    "-y", y_pstr, &(vpset->y_int),
		    0, 1, 1);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-y' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vpset->b_flag = vget_int(fid, prompt_flag,
			"-b", b_pstr, &(vpset->b_int),
			0, 1, 1)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpset->b_flag))
		{
		    fprintf(stderr, "\t\tb is required, please re-enter: \n");
		    vpset->b_flag = vget_int(fid, prompt_flag,
		    "-b", b_pstr, &(vpset->b_int),
		    0, 1, 1);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-b' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vpset->v_flag = vget_float(fid, prompt_flag,
			"-v", v_pstr, &(vpset->v_float),
			0.000000, 0.000000, 0.000000)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpset->v_flag))
		{
		    fprintf(stderr, "\t\tv is required, please re-enter: \n");
		    vpset->v_flag = vget_float(fid, prompt_flag,
		    "-v", v_pstr, &(vpset->v_float),
		    0.000000, 0.000000, 0.000000);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-v' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



