/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vthd.c
 >>>>
 >>>>      Program Name: vthd
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compute total harmonic distortion from FFT spectrum
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson, Mike Murillo
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:17:30 1991
 >>>>
 >>>>          Routines: main- the main program for vthd
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vthd.h"


/****************************************************************
 *
 * Routine Name:  main program for vthd
 *
 *       Input:  
 *      -i  input spectrum 
 *      -o  resulting output image 
 *
 *
 *      [-t] lets user choose spectrum type
 *		1 (choose amplitude type of spectrum),
 *		or 2 (choose power type of spectrum)
 *		   [default = 1] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image,*readimage();
        float thd;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        image = readimage(vthd->i_file);
        if (image == NULL) exit(1);
        CHECKINPUT(program, image);      /* Verify input images */
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvthd(image,vthd->t_toggle,&thd))
          {
            (void) fprintf(stderr, "lvthd Failed\n");
            exit(1);
          }
/* -main_library_call_end */

/* -main_after_lib_call */
        fprintf(stderr,"THD for image is %f %%\n",thd*100.0);
        exit(0);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vthd 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vthd :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompute total harmonic distortion from FFT spectrum\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
        fprintf(stderr,"Possible values for the -t argument:\n");
        fprintf(stderr,"  1 - spectrum is an amplitude spectrum\n");
        fprintf(stderr,"  2 - spectrum is a power spectrum\n\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input spectrum  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-t]  lets user choose spectrum type\n");
	fprintf(stderr, "\t\t1  (choose amplitude type of spectrum),\n");
	fprintf(stderr, "\t\tor 2  (choose power type of spectrum)\n");
	fprintf(stderr, "\t\t[default = 1]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vthd\n");
	fprintf(stderr, "\t[-U] Gives the usage for vthd\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vthd.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vthd.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vthd
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input spectrum \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*t_pstr = "\nEnter: (t) lets user choose spectrum type -- \n      \t\t1 (choose amplitude type of spectrum)\n\t\tor 2 (choose power type of spectrum)\n  [1]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vthd", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vthd.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vthd: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vthd.ans");
		}

	     }

	}

	/*
	 * allocate the vthd structure
	 */
	vthd = (vthd_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vthd_struct));

	/*
	 * get required arguments for vthd
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vthd->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vthd->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vthd->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vthd->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vthd->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vthd->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vthd->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vthd->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vthd->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vthd->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


	/*
	 * get optional toggles for vthd
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vthd->t_flag = vget_int(fid, prompt_flag,
		"-t", t_pstr, &(vthd->t_toggle),
		1, 0, 0);

		if ((vthd->t_toggle == 1 ) || 
		    (vthd->t_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vthd->t_flag = vget_int(fid, prompt_flag,
		"-t", t_pstr, &(vthd->t_toggle),
		1, 0, 0);

		if ((vthd->t_toggle != 1 ) && 
		    (vthd->t_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



