.TH splines 3U "2 February 1991" "Unidraw" "InterViews Reference Manual"
.SH NAME
OpenBSpline, S_OpenBSpline, F_OpenBSpline, SF_OpenBSpline,
SFH_OpenBSpline, ClosedBSpline, S_ClosedBSpline, F_ClosedBSpline,
SF_ClosedBSpline, SFH_ClosedBSpline \- structured graphics classes for
open and closed B-splines
.SH SYNOPSIS
.B #include <Unidraw/Graphic/splines.h>
.SH DESCRIPTION
OpenBSpline and ClosedBSpline are Vertices subclasses that serve as
abstract base classes for open and closed B-spline structured
graphics.  Predefined subclasses include S_OpenBSpline, F_OpenBSpline,
and SF_OpenBSpline, which draw stroked, filled, and stroked-filled
open B-splines, respectively; and S_ClosedBSpline, F_ClosedBSpline,
and SF_ClosedBSpline, which draw stroked, filled, and stroked-filled
closed B-splines, respectively.  The SFH_OpenBSpline and
SFH_ClosedBSpline subclasses are identical to their SF_-prefixed
counterparts, except they can detect hits on their control points in
addition to detecting hits on their visible parts.  The stroked
subclasses store a PSBrush, the filled subclasses store a PSPattern,
and the stroked-filled subclasses store one of each.
.SH OPENBSPLINE PROTECTED OPERATIONS
.TP
.B "OpenBSpline(Coord* x, Coord* y, int count, Graphic* = nil)"
OpenBSpline's constructor is protected to prevent instantiation of the
abstract base class.  The parameters are passed directly to the
Vertices constructor.
.SH OPENBSPLINE SUBCLASS PUBLIC OPERATIONS
.TP
.B "S_OpenBSpline(Coord* x, Coord* y, int count, Graphic* = nil)"
.ns
.TP
.B "F_OpenBSpline(Coord* x, Coord* y, int count, Graphic* = nil)"
.ns
.TP
.B "SF_OpenBSpline(Coord* x, Coord* y, int count, Graphic* = nil)"
.ns
.TP
.B "SFH_OpenBSpline(Coord* x, Coord* y, int count, Graphic* = nil)"
Constructors for the various predefined Rect subclasses.
.SH CLOSEDBSPLINE PROTECTED OPERATIONS
.TP
.B "ClosedBSpline(Coord* x, Coord* y, int count, Graphic* = nil)"
ClosedBSpline's constructor is protected to prevent instantiation of the
abstract base class.  The parameters are passed directly to the
Vertices constructor.
.SH CLOSEDBSPLINE SUBCLASS PUBLIC OPERATIONS
.TP
.B "S_ClosedBSpline(Coord* x, Coord* y, int count, Graphic* = nil)"
.ns
.TP
.B "F_ClosedBSpline(Coord* x, Coord* y, int count, Graphic* = nil)"
.ns
.TP
.B "SF_ClosedBSpline(Coord* x, Coord* y, int count, Graphic* = nil)"
.ns
.TP
.B "SFH_ClosedBSpline(Coord* x, Coord* y, int count, Graphic* = nil)"
Constructors for the various predefined Rect subclasses.
.SH SEE ALSO
Graphic(3U), Vertices(3U), geomobjs(3U), pspaint(3U)
