/**
 **	$Header: /import/dev-vis/image/imtools/v2.0/libim/src/RCS/imfmt.c,v 1.9 92/11/04 12:00:19 groening Exp $
 **	Copyright (c) 1989-1992  San Diego Supercomputer Center (SDSC)
 **		San Diego, California, USA
 **
 **	Users and possessors of this source code are hereby granted a
 **	nonexclusive, royalty-free copyright and design patent license to
 **	use this code in individual software.  License is not granted for
 **	commercial resale, in whole or in part, without prior written
 **	permission from SDSC.  This source is provided "AS IS" without express
 **	or implied warranty of any kind.
 **
 **	For further information contact:
 **		E-Mail:		info@sds.sdsc.edu
 **
 **		Surface Mail:	Information Center
 **				San Diego Supercomputer Center
 **				P.O. Box 85608
 **				San Diego, CA  92138-5608
 **				(619) 534-5000
 **/

#define HEADER	"	$Header: /import/dev-vis/image/imtools/v2.0/libim/src/RCS/imfmt.c,v 1.9 92/11/04 12:00:19 groening Exp $"

/**
 **  FILE
 **	imfmt.c		-  file format table for the image library
 **
 **  PROJECT
 **	libim		-  SDSC image manipulation library
 **
 **  DESCRIPTION
 **	imfmt.c contains the master file format table for the image
 **	library.  The table lists all of the image file formats supported
 **	and their attributes.
 **
 **  PUBLIC CONTENTS
 **			d =defined constant
 **			f =function
 **			m =defined macro
 **			t =typedef/struct/union
 **			v =variable
 **			? =other
 **
 **	ImFileFormats	v  list of file format information
 **
 **  PRIVATE CONTENTS
 **	im...		v  format-specific stuff for the table
 **
 **  HISTORY
 **	$Log:	imfmt.c,v $
 **	Revision 1.9  92/11/04  12:00:19  groening
 **	took the ImFileFormat info and put
 **	them in their corresponding image files.
 **	
 **	Revision 1.8  92/09/17  14:38:16  vle
 **	Added BMP, CUR, and ICO formats.  Re-ordered some declarations.
 **	Updated copyright notice.
 **	
 **	Revision 1.7  92/06/18  16:01:17  groening
 **	targa and viff formats added
 **	
 **	Revision 1.6  92/04/07  15:32:43  vle
 **	Re-ordered the format specifications for IRIS Rgb to be consistent
 **	with rest of imfmt.c.
 **	
 **	Revision 1.5  92/04/03  18:13:52  vle
 **	imconv can no longer output an xwd image without a colortable.
 **	Added lines to allow imconv to support 8-bit image read and 
 **	writes and changed read/write function names to be consistent
 **	with rest of code.
 **	
 **	Revision 1.4  91/10/03  09:01:29  nadeau
 **	Changed 'interlace' to 'interleave'.  Commented out CGM
 **	support.  Added EPS, ICON, and PCX support.  Changed
 **	PBM and RPBM entries to be multiple entries, one per
 **	format variant.  Updated support for XWD and RAS.  Changed
 **	comments for HDF, PS, PIC, and others (cosmetic changes).
 **	
 **	Revision 1.3  91/03/13  12:49:57  nadeau
 **	Fixed various can/can't handle pipe setting bugs.
 **	Reordered RGB alpha compression write preferences for TIFF.
 **	
 **	Revision 1.2  91/03/12  11:02:12  nadeau
 **	Changed pic support to allow pipe read and write.
 **	
 **	Revision 1.1  91/03/08  14:39:30  nadeau
 **	Initial revision
 **	
 **/

#include "iminternal.h"





/*
 *  FORMATS
 *	These #define's enable inclusion of the file format declarations
 *	and initializations for the format table at the end of the file.
 */

/* #define art */
/* #define bdf */
/* #define cgm */
#define bmp
#define cur
#define eps
/* #define fbm */
/* #define fits */
/* #define flux */
#define gif
#define hdf
#define ico
#define icon
#define iff
/* #define ilbm */
#define mpnt
#define pbm
#define pcx
#define pgm
#define pic
#define pict
#define pix
#define pnm
#define ppm
#define ps
#define ras
#define rgb
#define rla
#define rle
/* #define snf */
#define synu
#define tga 
#define tiff
/* #define uil */
#define viff
#define x
#define xbm
#define xwd 





/*
 *  GLOBALS
 *	im...		-  format-specific stuff for the table
 *
 *  DESCRIPTION
 *	The ImFileFormats table later in this file is initialized to lots
 *	of attributes for all of the image file formats supported by the
 *	library.  Many of the fields on the table are pointers to arrays
 *	listing features of the format.  The global declarations that follow
 *	are those arrays, per file format.
 *
 *  HOW TO DECLARE STUFF FOR A NEW FORMAT
 *	Assuming you've already written the format read and write code,
 *	do the following in THIS file (Xyz is the sample name of a format):
 *
 *	1.	Declare Xyz's single read function as external.
 *			extern int ImXyzRead( );
 *
 *	2.	Declare Xyz's multiple write functions as external.
 *			extern int ImXyzWrite8_C( );
 *			extern int ImXyzWriteRGB( );
 *			extern int ImXyzWrite8_RLE_C( ),
 *			extern int ImXyzWriteRGB_RLE( );
 *		Note the naming convention (which we encourage):
 *
 *			<name> := "Im" <fmt> "Write" <depth_info> "_" <att_info>
 *
 *		<fmt> is the mneumonic for the format (such as "Xyz").
 *
 *		<depth_info> is the image type and depth information in the
 *		form:
 *
 * 			<depth_info> := <type> <#chan> "_" <dep>
 *
 *		<type> is either "In" for indexed, or "Rgb" for RGB images.
 *		<#chan> is the # of channels (usually 1 or 3).
 *		<dep> is the channel depth (usually 1 or 8).
 *
 *		<att_info> is the attribute information in the form:
 *
 *			<att_info> ::= "_" <comp> "_C" "_A"
 *
 *		<comp> is the compression scheme.  Left off if uncompressed.
 *		"_C" is on if there's a CLT.  "_A" if there's an alpha.
 *
 *	3.	Declare and initialize a names array listing all names the
 *		format is known by.  List the "primary" name (most common)
 *		first in the list.  End the list of strings with a NULL.
 *			private char *imXyzNames[ ] ={ "xyz", "yzx", NULL};
 *		Format name checking is case insensitive, so only list names
 *		in lower case.
 *
 *	4.	Declare and initialize a magic number array, if the format
 *		has a magic number.  If not, skip this step.
 *			private uchar imXyzMagicNumber[ ] = { 0xAB, 0xCD };
 *		The number of bytes in the magic number is noted later in
 *		the table proper.
 *
 *	5.	Declare and initialize a read map that shows how file image
 *		attributes are mapped to library VFB's.
 *			private ImFileFormatReadMap imXyzReadMap[ ] =
 *			{
 *			    { IN,1,8,   C,     IMVFBINDEX8, C },
 *			    { IN,1,8,   RLE|C, IMVFBINDEX8, C },
 *			    { RGB,3,8,  0,     IMVFBRGB,    0 },
 *			    { RGB,3,8,  RLE,   IMVFBRGB,    0 },
 *			    { -1,       0,     -1,          0 },
 *			};
 *		See below for more details.
 *
 *		If the format doesn't support read, skip this step.
 *
 *	6.	Declare and initialize a write map that shows how library VFB's
 *		are mapped to image attributes.
 *			private ImFileFormatWriteMap imXyzWriteMap[ ] =
 *			{
 *			  {IMVFBINDEX8,C, IN,1,8,  C,    ImXyzWrite8_C },
 *			  {IMVFBINDEX8,C, IN,1,8,  RLE|C,ImXyzWrite8_RLE_C},
 *			  {IMVFBRGB,   0, RGB,3,8, 0,    ImXyzWriteRGB },
 *			  {IMVFBRGB,   0, RGB,3,8, RLE,  ImXyzWriteRGB_RLE},
 *			  {-1,         0, -1,      0,    NULL },
 *			};
 *		See below for more details.
 *
 *		If the format doesn't support write, skip this step.
 *
 *	7.	Jump down to the file format table declaration and add
 *		another initialization.  Read comments there for how to do it.
 *
 *  MAPPING TABLE INITIALIZATIONS
 *	The mapping tables tell the generic portions of the library what the
 *	various formats are capable of handling.
 *
 *    Read Mapping
 *	The read mapping table is primarily informational.  Very little code
 *	uses it except for nice printouts.
 *
 *	Columns 1-3 describe the image storage of the incomming image.  The
 *	first is a type indicator (color index or RGB).  The second is the
 *	number of channels of data (usually 1 or 3).  The third is the size,
 *	in bits, of each channel (usually 1 or 8).  Do not include the
 *	alpha channel (if any) in the depth.  That info goes in Column 4.
 *
 *		Example:	IN,1,8		-- 8-bit index
 *				RGB,3,8		-- 3*8-bit = 24-bit RGB
 *
 *	Column 4 is a mask of attributes for the incomming image.  The
 *	mask indicates if a CLT or alpha plane is included, how images
 *	are interleaved (RGB only), and what compression scheme is used.
 *
 *		Example:	0		-- nothing
 *				C		-- has CLT
 *				C|A		-- has CLT and alpha
 *				A|RLE|PI	-- plane interleaved RLE & alpha
 *
 *	Column 5 is the VFB type of the resulting image.  Do not include
 *	IMVFBALPHA if an alpha plane is present.  That info goes in Column 6.
 *
 *		Example:	IMVFBINDEX8	-- 8-bit index
 *				IMVFBRGB	-- RGB
 *
 *	Column 6 is a mask of attributes for the VFB.  The mask indicates if
 *	a CLT or alpha plane is included.  Interleave and compression codes
 *	are inappropriate for this column.
 *
 *		Example:	0		-- no clt or alpha
 *				C|A		-- clt and alpha
 *
 *	For example:  a mythical format "Xyz" supports 8-bit color index and
 *	24-bit true-color RGB images.  8-bit images always have a CLT.  RGB
 *	images never do.  RGB images may be uninterleaved, or plane interleaved.
 *	And finally, the image could be uncompressed, or run-length encoded
 *	(RLE).
 *
 *	private ImFileFormatReadMap imXyzReadMap[ ] =
 *	{
 *		{ IN,1,8,	RLE | C,	IMVFBINDEX8,	C },
 *		{ IN,1,8,	C,		IMVFBINDEX8,	C },
 *		{ RGB,3,8,	RLE | PI,	IMVFBRGB,	0 },
 *		{ RGB,3,8,	PI,		IMVFBRGB,	0 },
 *		{ RGB,3,8,	RLE,		IMVFBRGB,	0 },
 *		{ RGB,3,8,	0,		IMVFBRGB,	0 },
 *		{ -1,           0,		-1,		0 },
 *	};
 *
 *	Always end the list with a -1 depth entry.
 *
 *	8-bit index occurs twice, once with "RLE" Or-ed into the incomming
 *	attribute mask, and once without.  If no compression flag is Or-ed
 *	in, it is assumed to mean uncompressed.
 *
 *	24-bit RGB occurs four times:  twice with "RLE", and twice without.
 *	For each of the RLE cases, one has "PI" for "Plane Interleave"
 *	Or-ed in, and one doesn't.  Likewise with the non-"RLE" cases.
 *
 *	The "C", "PI", "RLE", and so on flags are short-cut #define's used
 *	for this file only.  They include:
 *
 *		C	-  CLT is included
 *		A	-  Alpha plane is included
 *
 *		LI	-  Line interleaved RGB
 *		PI	-  Plane interleaved RGB
 *
 *		RLE	-  Run-length encoded
 *		LZW	-  Lempel-Ziv & Welsh compressed
 *		PB	-  Macintosh PackBits
 *		DCT	-  Descrete Cosine Transform compression
 *
 *		IN	-  Index type image
 *		RGB	-  RGB type image
 *
 *	If C is not present, it is assumed there is no CLT.
 *
 *	If A is not present, it is assumed there is no alpha plane.
 *
 *	If neither LI or PI are present, it is assumed that the image
 *	is not interleaved.
 *
 *	If none of RLE, LZW, PB, or DCT are present, it is assumed that the
 *	image is uncompressed.
 *
 *    Write Mapping
 *	The write mapping table is critical.  It is used by the ImFileWrite
 *	code to convert the VFB to be written into something the format can
 *	write.  Depth's are changed.  CLT's are added.  And so on.  The
 *	table is also used to make nice printouts.
 *
 *	Column 1 is the incomming VFB type.  Do not include IMVFBALPHA if an
 *	alpha plane is to be present.  That info goes in column 2.
 *
 *		Example:	IMVFBINDEX8	-- 8-bit index
 *				IMVFBRGB	-- RGB
 *				IMVFBMONO	-- monochrome index
 *
 *	Column 2 is a mask of required attributes for the incomming VFB.  The
 *	mask indicates if a CLT or alpha plane must be present.  Interleave
 *	and compression scheme codes are inappropriate for this column.
 *
 *		Example:	0		-- neither clt or alpha
 *				C|A		-- clt and alpha
 *
 *	Columns 3-5 are the image type and depth attributes of the outgoing
 *	(in the file) image.  This includes the type (index or RGB), number
 *	of channels (usually 1 or 3), and number of bits per channel (usually
 *	1 or 8).  Do not include an alpha channel in the depth.  That goes
 *	in column 6.
 *
 *		Example:	IN,1,8		-- 8-bit index
 *				RGB,3,8		-- 3*8-bit = 24-bit RGB
 *
 *	Column 6 is a mask of resulting attributes for the outgoing image.
 *	The mask indicates if a CLT or alpha plane is included, how images
 *	are interleaved (RGB only), and what compression scheme is used.
 *
 *		Example:	0		-- no clt, no alpha, ...
 *				C|A|RLE		-- clt + alpha + RLE compress
 *				A|LI		-- alpha + line interleaved
 *
 *	Column 7 is an integer function pointer to the function to do the
 *	writing of that variant of the format.
 *
 *	For example:  the same mythical "Xyz" format used for the read map
 *	example is used.
 *
 *	private ImFileFormatWriteMap imXyzWriteMap[ ] =
 *	{
 *		{ IMVFBINDEX8, 0,  IN,1,8,	RLE | C, ImXyzWrite8_RLE_C},
 *		{ IMVFBINDEX8, C,  IN,1,8,	RLE | C, ImXyzWrite8_RLE_C},
 *		{ IMVFBINDEX8, 0,  IN,1,8,	C,       ImXyzWrite8_C },
 *		{ IMVFBINDEX8, C,  IN,1,8,	C,       ImXyzWrite8_C },
 *
 *		{ IMVFBRGB,    0,  RGB,3,8,	RLE | PI,ImXyzWriteRGB_RLE_PI },
 *		{ IMVFBRGB,    0,  RGB,3,8,	RLE,     ImXyzWriteRGB_RLE },
 *		{ IMVFBRGB,    0,  RGB,3,8,	PI,      ImXyzWriteRGB_PI},
 *		{ IMVFBRGB,    0,  RGB,3,8,	0,       ImXyzWriteRGB },
 *		{ -1,	       0,  -1,		0,	 NULL },
 *	};
 *
 *	Always end the list with a -1 VFB type entry.
 *
 *	When multiple entries are made for the same VFB type and incomming
 *	attributes, list from "best" to "worst".  List compressed versions
 *	before uncompressed.  List plane and line interleaved RGB before
 *	uninterleaved.  List non-alpha versions before alpha, and so on.
 *
 *	8-bit VFB's occur four times:  twice for RLE output encoding, and
 *	twice without.  Within each of those, one occurrence requires no CLT,
 *	and one requires one.  However, both of those cases go to the same
 *	routine (which presumably checks if the VFB has a CLT, and if not
 *	creates one).
 *
 *	24-bit RGB VFB's occur four times:  twice for RLE output encoding,
 *	and twice without.  Within each of those, one occurrence is
 *	uninterleaved, and one plane interleaved.
 *
 *	There may not be two identical lines in the table.  However, any number
 *	of lines may use the same input conditions and/or the same write
 *	function.
 *
 *	ImFileWrite() checks this table and the flagsTable giving the user's
 *	write request flags, and decides which write function to call.  If
 *	it can't find one that matches the request, and it can't convert the
 *	VFB into one that matches, then it returns an error.
 */






/*
 *  TYPEDEF & STRUCT
 *	ImFileFormats	-  list of file format information
 *	im...		-  format-specific magic #'s and equiv names
 *
 *  DESCRIPTION
 *	The ImFileFormat struct describes everything we know generically
 *	about a file format supported by the image library.  ImFileFormats
 *	is an array of such structs that lists all the supported formats.
 *
 *  HOW TO ADD A NEW FORMAT
 *	1.	Write the read, write, and info query routines.
 *	2.	Declare the functions in the format's file.
 *	3.	Declare and initialize an array of character strings with
 *		the equivalent names for the format.
 *	4.	Declare and initialize an array of bytes with the format's
 *		magic number, if any.
 *	5.	Add an entry to the ImFileFormats array giving the format's
 *		ImFileFormat address (see below)
 *
 *			Please add new entries in alphabetical order!
 *			It makes printing of supported format lists look better.
 *
 *	6.	Update the Makefile to include your new source code and
 *		recompile the library.  Relink all image library tools.
 *
 *
 *      EXAMPLE: RGB - Silicon Graphics Iris RGB file
 *
 * extern int ImRgbRead( );
 * extern int ImRgbWriteRaw8( ), ImRgbWriteRLE8( );
 * extern int ImRgbWriteRawRGB( ), ImRgbWriteRLERGB( );
 * private char *imRgbNames[ ]  = { "rgb", "iris", "sgi", NULL };
 * private uchar imRgbMagicNumber[ ] = { 0x01, 0xDA };
 * private ImFileFormatReadMap imRgbReadMap[ ] =
 * {
 *            in                   out                                       
 *            type,ch,dep, attr.   VFB type        attr.                     
 *         { IN,1,8,       LI,     IMVFBINDEX8,    0 },
 *         { IN,1,8,       RLE,    IMVFBINDEX8,    0 },
 *         { RGB,3,8,      LI,     IMVFBRGB,       0 },
 *         { RGB,3,8,      RLE,    IMVFBRGB,       0 },
 *         { -1,           0,      -1,             0 },
 * };
 * private ImFileFormatWriteMap imRgbWriteMap[ ] =
 * {
 *            in                   out                                       
 *            VFB type,    attr.,  type,ch,dep,    attr.,  func              
 *         { IMVFBINDEX8,  0,      IN,1,8,         LI,     ImRgbWriteRaw8 },
 *         { IMVFBINDEX8,  0,      IN,1,8,         RLE,    ImRgbWriteRLE8 },
 *         { IMVFBRGB,     0,      RGB,3,8,        LI,     ImRgbWriteRawRGB },
 *         { IMVFBRGB,     0,      RGB,3,8,        RLE,    ImRgbWriteRLERGB },
 *         { -1,           0,      -1,             0,      NULL },
 * };
 * 
 * extern ImFileMagic imFileRgbMagic1=
 *         {
 *           0, 2, imRgbMagicNumber
 *         };
 * 
 * private ImFileMagic *imFileRgbMagic []=
 *         {
 *           &imFileRgbMagic1,
 *           NULL
 *         };
 * 
 * extern ImFileFormat ImFileRgbFormat =
 *         { imRgbNames, "SGI RGB image file",
 *           "Silicon Graphics, Inc.",
 *           "8-bit color index without CLT and 24-bit RGB color images,\n\
 * uncompressed (verbatim) and RLE-compressed.",
 *           "8-bit color index without CLT and 24-bit RGB color images,\n\
 * uncompressed (verbatim) and RLE-compressed.",
 *           imFileRgbMagic,
 *           FALSE, TRUE,
 *           FALSE, FALSE,
 *           ImRgbRead, imRgbReadMap, imRgbWriteMap
 *         };
 * 
 */


#ifdef art
	extern ImFileFormat ImFileArtFormat;
#endif /* art */

#ifdef bmp
	 extern ImFileFormat ImFileBmpFormat;
#endif /* bmp */

#ifdef cgm
	 extern ImFileFormat ImFileCgmFormat;
#endif /* cgm */

#ifdef cur
	 extern ImFileFormat ImFileCurFormat;
#endif /* cur */

#ifdef eps
	 extern ImFileFormat ImFileEpsFormat;
#endif /* eps */

#ifdef fbm
	 extern ImFileFormat ImFileFbmFormat;
#endif /* fbm */

#ifdef fps
	 extern ImFileFormat ImFileFpsFormat;
#endif /* fps */

#ifdef gif
	 extern ImFileFormat ImFileGifFormat;
#endif /* gif */

#ifdef hdf
	 extern ImFileFormat ImFileHdfFormat;
#endif /* hdf */

#ifdef ico
	 extern ImFileFormat ImFileIcoFormat;
#endif /* ico */

#ifdef icon
	 extern ImFileFormat ImFileIconFormat;
#endif /* icon */

#ifdef iff
	 extern ImFileFormat ImFileIffFormat;
#endif /* iff */

#ifdef ilbm
	 extern ImFileFormat ImFileIlbmFormat;
#endif /* ilbm */

#ifdef mpnt
	 extern ImFileFormat ImFileMpntFormat;
#endif /* mpnt */

#ifdef pbm
	 extern ImFileFormat ImFilePbmFormat;
#endif /* pbm */

#ifdef pcx
	 extern ImFileFormat ImFilePcxFormat;
#endif /* pcx */

#ifdef pgm
	 extern ImFileFormat ImFilePgmFormat;
#endif /* pgm */

#ifdef pic
	 extern ImFileFormat ImFilePicFormat;
#endif /* pic */

#ifdef pict
	 extern ImFileFormat ImFilePictFormat;
#endif /* pict */

#ifdef pix
	 extern ImFileFormat ImFilePixFormat;
#endif /* pix */

#ifdef ppm
	 extern ImFileFormat ImFilePpmFormat;
#endif /* ppm */

#ifdef pnm
	 extern ImFileFormat ImFilePnmFormat;
#endif /* pnm */

#ifdef ps
	 extern ImFileFormat ImFilePsFormat;
#endif /* ps */

#ifdef ras
	 extern ImFileFormat ImFileRasFormat;
#endif /* ras */

#ifdef rgb
	 extern ImFileFormat ImFileRgbFormat;
#endif /* rgb */

#ifdef rla
	 extern ImFileFormat ImFileRlaFormat;
#endif /* rla */

#ifdef rle
	extern ImFileFormat ImFileRleFormat;
#endif /* rle */

#ifdef synu
	 extern ImFileFormat ImFileSynuFormat;
#endif /* synu */

#ifdef tga
	 extern ImFileFormat ImFileTgaFormat;
#endif /* tga */

#ifdef tiff
	 extern ImFileFormat ImFileTiffFormat;
#endif /* tiff */

#ifdef viff
	 extern ImFileFormat ImFileViffFormat;
#endif /* viff */

#ifdef x
	 extern ImFileFormat ImFileXFormat;
#endif /* x */

#ifdef xbm
	 extern ImFileFormat ImFileXbmFormat;
#endif /* xbm */

#ifdef xwd
	 extern ImFileFormat ImFileXwdFormat;
#endif /* xwd */




public ImFileFormat  *ImFileFormats[] =
{


#ifdef art
	&ImFileArtFormat,
#endif /* art */


#ifdef bmp
	 &ImFileBmpFormat,
#endif /* bmp */


#ifdef cgm
	 &ImFileCgmFormat,
#endif /* cgm */


#ifdef cur
	 &ImFileCurFormat,
#endif /* cur */


#ifdef eps
	 &ImFileEpsFormat,
#endif /* eps */


#ifdef fbm
	 &ImFileFbmFormat,
#endif /* fbm */


#ifdef fps
	 &ImFileFpsFormat,
#endif /* fps */


#ifdef gif
	 &ImFileGifFormat,
#endif /* gif */


#ifdef hdf
	 &ImFileHdfFormat,
#endif /* hdf */


#ifdef ico
	 &ImFileIcoFormat,
#endif /* ico */


#ifdef icon
	 &ImFileIconFormat,
#endif /* icon */


#ifdef iff
	 &ImFileIffFormat,
#endif /* iff */


#ifdef ilbm
	 &ImFileIlbmFormat,
#endif /* ilbm */


#ifdef mpnt
	 &ImFileMpntFormat,
#endif /* mpnt */


#ifdef pbm
	 &ImFilePbmFormat,
#endif /* pbm */


#ifdef pcx
	 &ImFilePcxFormat,
#endif /* pcx */


#ifdef pgm
	 &ImFilePgmFormat,
#endif /* pgm */


#ifdef pic
	 &ImFilePicFormat,
#endif /* pic */


#ifdef pict
	 &ImFilePictFormat,
#endif /* pict */


#ifdef pix
	 &ImFilePixFormat,
#endif /* pix */


#ifdef ppm
	 &ImFilePpmFormat,
#endif /* ppm */


#ifdef pnm
	 &ImFilePnmFormat,
#endif /* pnm */


#ifdef ps
	 &ImFilePsFormat,
#endif /* ps */


#ifdef ras
	 &ImFileRasFormat,
#endif /* ras */


#ifdef rgb
	 &ImFileRgbFormat,
#endif /* rgb */


#ifdef rla
	 &ImFileRlaFormat,
#endif /* rla */


#ifdef rle
	 &ImFileRleFormat,
#endif /* rle */


#ifdef synu
	 &ImFileSynuFormat,
#endif /* synu */


#ifdef tga
	 &ImFileTgaFormat,
#endif /* tga */

#ifdef tiff
	 &ImFileTiffFormat,
#endif /* tiff */


#ifdef viff
	 &ImFileViffFormat,
#endif /* viff */


#ifdef x
	 &ImFileXFormat,
#endif /* x */


#ifdef xbm
	 &ImFileXbmFormat,
#endif /* xbm */


#ifdef xwd
	 &ImFileXwdFormat,
#endif /* xwd */

	  NULL

};
