'\"t
.if t .TH IMICO 3IM "August 19, 1992" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMICO 3IM "August 19, 1992" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
imico \- Microsoft Windows ICO file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "ico", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "ico", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "ico", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "ico", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
.LP
\fBico\fR image files are generated by programs running in the
Microsoft Windows 3.0, and later, environments.  This environment
commonly runs on IBM PC's and compatibles.
.LP
\fBico\fR image
files store one or more icons used by Windows programs.  Icons
can only have widths and heights of fixed values:  16, 32, or 64.
Bitmap images and cursors are instead stored in the \fBbmp\fR and \fBcur\fR
Windows formats.  See \fBimbmp\fR (3IM) and \fBimcur\fR (3IM) for
details on these formats.
.SH "FILE RECOGNITION"
Microsoft Windows \fBico\fR files are recognized by the following
filename suffix:  .ico.
.SH NOTES
SDSC image library support of the 
Microsoft Windows \fBico\fR format does not require
use of any Windows libraries and contains no proprietary code.  
Microsoft Windows \fBico\fR format handling
is available on any machine for which the SDSC image library is available.
.SS "Reading Microsoft Windows ICO files"
The SDSC image library reads multiple non-compressed, pixel packed
1- and 4-bit color indexed icon images as \fBIMVFBINDEX8\fR VFBs
with alpha channels and CLT's.  An icon's XOR mask is read in as
the main image.  The associated AND mask is read in as an
alpha channel for the same VFB.
.LP
3-bit color indexed icon images are currently
not supported due to the lack of documentation on the pixel packing
method used for this type of image.
.SS "Writing Microsoft Windows ICO files"
Image library \fBIMVFBMONO\fR VFBs are written to non-compressed,
pixel packed 1-bit \fBico\fR files.
Image library \fBIMVFBINDEX8\fR VFBs are written to non-compressed,
pixel packed 4-bit \fBico\fR files.  The color channels of the VFB
are written as the icon's XOR mask.  The VFB's alpha channel is
written as the AND mask.
.LP
Other image library VFB types are converted to \fBIMVFBMONO\fR VFBs or
\fBIMVFBINDEX8\fR with alpha channels prior to being written out.  See the
\fBImFileWrite\fR(3IM) \fBman\fP page for details.
.SS "AND and XOR masks"
An \fBico\fR image file contains multiple icons.  Each icon is
composed of two separate images, an AND mask and a XOR mask.
Microsoft Windows uses these masks to generate a displayed icon as follows:
.RS 0.5i
.LP
Windows first does a bitwise AND operation on the display pixels using the
AND mask.  This preserves or removes existing color pixels.  Afterwards,
Windows does a bitwise XOR operation on the display using the XOR
mask.  This sets the final color of each icon pixel.
.RE
.LP
The AND mask is typically used to create a hole on the screen into which
to paint the colors specified by the XOR mask.  This use of the AND mask
is similar to a standard image alpha channel and is why the SDSC Image
Tools read the AND mask into a VFB's alpha channel, and place the XOR mask
in the VFB's color index channel.
.LP
For example, the following AND and XOR masks form a capital 'K' icon
(example taken from the \fIMicrosoft Windows Programmer's Reference\fR):
.sp
.if n .ig END
.(z
.TS
tab(:) center;
 c s s s s s s s lw(.5i) c s s s s s s s
|c s s s s s s s|lw(.5i)|c s s s s s s s|
|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lww(.5i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|lw(.1i)|.
_::_
AND mask::XOR mask
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:1:1:1:0:0:1::1:1:0:0:0:1:1:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:1:1:0:0:1:1::1:1:0:0:1:1:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:1:0:0:1:1:1::1:1:0:1:1:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:0:0:1:1:1:1::1:1:1:1:0:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:0:0:1:1:1:1::1:1:1:1:0:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:1:0:0:1:1:1::1:1:0:1:1:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:1:1:0:0:1:1::1:1:0:0:1:1:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:1:1:1:0:0:1::1:1:0:0:0:1:1:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
.TE
.)z
.sp
.(z
.ne 3.0i
.TS
tab(:) allbox center;
c s s s s s s s
lw(.1i) lw(.1i) lw(.1i) lw(.1i) lw(.1i) lw(.1i) lw(.1i) lw(.1i).
Resulting Icon
K:K: : : :K:K: 
K:K: : :K:K: : 
K:K: :K:K: : : 
K:K:K:K: : : : 
K:K:K:K: : : : 
K:K: :K:K: : : 
K:K: : :K:K: : 
K:K: : : :K:K: 
.TE
.)z
.END
.if t .ig END
.(z
.TS
tab(:) center;
c s s s s s s s lw(.1i) c s s s s s s s
c s s s s s s s lw(.1i) c s s s s s s s
l l l l l l l l lw(.1i) l l l l l l l l.
_::_
AND mask::XOR mask
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:1:1:1:0:0:1::1:1:0:0:0:1:1:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:1:1:0:0:1:1::1:1:0:0:1:1:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:1:0:0:1:1:1::1:1:0:1:1:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:0:0:1:1:1:1::1:1:1:1:0:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:0:0:1:1:1:1::1:1:1:1:0:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:1:0:0:1:1:1::1:1:0:1:1:0:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:1:1:0:0:1:1::1:1:0:0:1:1:0:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
0:0:1:1:1:0:0:1::1:1:0:0:0:1:1:0
_:_:_:_:_:_:_:_::_:_:_:_:_:_:_:_
.TE
.)z
.sp
.(z
.ne 3.0i
.TS
tab(:) center;
c s s s s s s s
c s s s s s s s
l l l l l l l l.
_
Resulting Icon
_:_:_:_:_:_:_:_
K:K: : : :K:K: 
_:_:_:_:_:_:_:_
K:K: : :K:K: : 
_:_:_:_:_:_:_:_
K:K: :K:K: : : 
_:_:_:_:_:_:_:_
K:K:K:K: : : : 
_:_:_:_:_:_:_:_
K:K:K:K: : : : 
_:_:_:_:_:_:_:_
K:K: :K:K: : : 
_:_:_:_:_:_:_:_
K:K: : :K:K: : 
_:_:_:_:_:_:_:_
K:K: : : :K:K: 
_:_:_:_:_:_:_:_
.TE
.)z
.END
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
Microsoft Windows \fBico\fR file reading returns the following error codes:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEDEPTH	Image depth not supported
IMEMAGIC	Bad magic number in header
IMEPLANES	Unknown image plane configuration
IMECLTLENGTH	Bad CLT length
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fIMicrosoft Windows Programmer's Reference Volumes 3 and 4\fR,
Microsoft, Inc.
.SH "SEE ALSO"
\fBImIntro\fR(3IM),
\fBImErrNo\fR(3IM),
\fBimbmp\fR(3IM),
\fBimcat\fR(3IM),
\fBimconv\fR(1IM),
\fBimcur\fR(3IM),
\fBimfile\fR(1IM),
\fBimformats\fR(1IM),
\fBimicon\fR(3IM),
\fBimsplit\fR(3IM),
\fBimxbm\fR(1IM)
.SH AUTHOR
Toan-Vinh Le
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
