/* Screen and .gle driver for pc */
#include "all.h"
#include "vdevice.h"
#define false 0
#define true (!false)
#ifdef __TURBOC__
#include <graphics.h>
#else		/* define dummy routines so it will compile on vax */
setcolor(){}
setlinestyle(){}
settextjustify(){}
closegraph(){}
detectgraph(){} 
getmaxcolor(){} 
outtext(){}
getmaxx(){}
getmaxy(){}
grapherrormsg(){}
graphresult(){ return 0;}
initgraph(){}
lineto(){}
moveto(){}
#define SOLID_LINE 1
#define DASHED_LINE 2
#endif
#include <math.h>
int ingraphmode;
/*---------------------------------------------------------------------------*/
#define pi 3.141592653
#define true (!false)
int getch(void);
int kbhit(void);
extern int gle_nspeed;
extern int gle_speed;
/*---------------------------------------------------------------------------*/
/* The global variables for the PC screen driver */
/*-----------------------------------------------*/

#define gerr() ee = graphresult(); if (ee!=0) printf("Graph error: %s \n",grapherrormsg(ee));
#define textmode() {getch(); restorecrtmode();}
#define graphmode() {getch(); setgraphmode(v_graphmode);}

float v_scale, v_xscale, v_yscale;
#define xsizecm 21.0
#define ysizecm 18.0
#define sx(v) ( (int) ((v) * v_xscale)+1)
#define sy(v) ( v_maxy - ((int) ((v) * v_yscale)))
#define rx(v) ( (int) ((v) * v_xscale)+1)
#define ry(v) ( v_maxy - ((int) ((v) * v_yscale)))
char *gledir(char *s);
int v_graphmode;
int v_fillstyle=1,v_fillcolor;
int vv_lstyle,v_lwidth;
int v_maxy;
static int ee;
FILE *gf;
extern char input_file[];
char *bgidir();
/*---------------------------------------------------------------------------*/
v_open(float width, float height)
{
	static int g_driver,g_error;
	float f;
	char bigfile[80];
	char glefile[80];

	strcpy(bigfile,input_file);
	if (strchr(bigfile,'.')==NULL) {
		gprint("Error in file name,  {%s} \n",input_file);
		gle_abort("error in file name \n");
	}
	*strchr(bigfile,'.') = 0;
	strcpy(glefile,bigfile);
	strcat(glefile,".gle");
	strcat(bigfile,".big");
	gf = fopen(glefile,"r");
	if (gf==NULL) { /* then it doesn't exist, so lets create it */
		gf = fopen(glefile,"w");
		if (gf==NULL) gprint("Failed to create {%s} \n",glefile);
		else {
			fprintf(gf,"size 24 18\n");
			fprintf(gf,"bigfile %s\n",bigfile);
			fclose(gf);
		}
	} else fclose(gf);


	gf = fopen(bigfile,"w");
	if (gf==NULL) {
		printf("Unable to open output gle file out.gle\n");
		abort();
	}
	gle_nspeed = 2;
#ifdef __TURBOC__
	detectgraph(&g_driver, &v_graphmode);
	if (g_driver<0) {
		printf("No graphics hardware detected !!!!! \n");
		gle_abort("Could not load BGI graphics\n");
	}
	ingraphmode = true;
	initgraph(&g_driver,&v_graphmode,bgidir());
	g_error = graphresult();
	if (g_error<0) {
		printf("Init graph error %s\n",grapherrormsg(g_error));
		ingraphmode = false; gle_abort("Init graph error\n");
	}

	/* Get largest rectangle we can fit on the screen */
	v_scale = xsizecm / width;
	f = ysizecm / height;
	if (f<v_scale) v_scale = f;

	v_xscale = v_scale * (getmaxx()-2) / xsizecm; /* Device Scale X, Device Scale y */
	v_yscale = v_scale * (getmaxy()-22) / ysizecm;
	v_maxy = getmaxy()-21;
	setcolor(getmaxcolor());
	setfillstyle(SOLID_FILL,getmaxcolor());
	bar(1,1,getmaxx(),getmaxy());
	setcolor(0);
#endif
}
/*---------------------------------------------------------------------------*/
v_close()
{
	ingraphmode = false;
#ifdef __TURBOC__
	text_inkey();
#endif
	closegraph();
	fclose(gf);
}
/*---------------------------------------------------------------------------*/
v_lstyle(char *s)
{
	if (*s == 0) s = "1";
	vv_lstyle = DASHED_LINE;
	if (strcmp(s,"")==0) vv_lstyle = SOLID_LINE;
	if (strcmp(s,"1")==0) vv_lstyle = SOLID_LINE;
	setlinestyle(vv_lstyle,0,v_lwidth);
	fprintf(gf,"set lstyle %s\n",s);
	gerr();
}
/*---------------------------------------------------------------------------*/
v_line(float zx,float zy)
{
#ifndef unix
	if (gle_speed) getch();
#endif
	lineto(sx(zx),sy(zy));
	fprintf(gf,"aline %g %g \n",zx,zy);
}
v_move(float zx,float zy)
{
	moveto(sx(zx),sy(zy));
	fprintf(gf,"amove %g %g \n",zx,zy);
}
/*---------------------------------------------------------------------------*/
v_color(char *s)
{
	int i;
	i = 0;
	if (*s == 0) s = "BLACK";
	if (strcmp(s,"RED")==0) i = 12;
	if (strcmp(s,"BLUE")==0) i = 9;
	if (strcmp(s,"GREEN")==0) i = 10;
	if (strcmp(s,"YELLOW")==0) i = 14;
	if (strcmp(s,"MAGENTA")==0) i = 5;
	if (strcmp(s,"BLACK")==0) i = 0;
	if (strcmp(s,"WHITE")==0) i = getmaxcolor();
	if (i>=getmaxcolor()) i = 0;
	setcolor(i);
	fprintf(gf,"set color %s\n",s);
}
v_gsave()
{
	fprintf(gf,"gsave \n");
}
v_grestore()
{
	fprintf(gf,"grestore \n");
}
v_text(char *s)
{
	fprintf(gf,"text %s\n",s);
	outtext(s);
}
v_set_hei(float g)
{
	fprintf(gf,"set hei %g\n",g);
}
v_set_just(char *s)
{
	if (strcmp(s,"RC")==0) settextjustify(2,0);
	if (strcmp(s,"TC")==0) settextjustify(1,2);
	if (strcmp(s,"BC")==0) settextjustify(1,0);
	if (strcmp(s,"CC")==0) settextjustify(1,1);
	if (strcmp(s,"LEFT")==0) settextjustify(0,0);
	fprintf(gf,"set just %s\n",s);
}
v_rotate(float g)
{
	fprintf(gf,"rotate %g \n",g);
}
v_marker(char *m)
{
	settextjustify(1,1);
	outtext("o");
	fprintf(gf,"marker %s\n",m);
}
