/* Screen and .gle driver for pc */
#include "all.h"
#include "vdevice.h"
#define false 0
#define true (!false)
#define SOLID_LINE 1
#define DASHED_LINE 2
#include <math.h>
#include "mygraph.h"
#include "justify.h"
/*---------------------------------------------------------------------------*/
#define pi 3.141592653
#define true (!false)
int getch(void);
int kbhit(void);
extern int gle_nspeed;
extern int gle_speed;
/*---------------------------------------------------------------------------*/
/* The global variables for the PC screen driver */
/*-----------------------------------------------*/

float v_scale, v_xscale, v_yscale;
char *gledir(char *s);
int v_graphmode;
int v_fillstyle=1,v_fillcolor;
int vv_lstyle,v_lwidth;
int v_maxy;
static int ee;
FILE *gf;
extern char input_file[];
char *bgidir();
/*---------------------------------------------------------------------------*/
v_open(float width, float height)
{
	static int g_driver,g_error;
	float f;
	char bigfile[80];
	char glefile[80];

	strcpy(bigfile,input_file);
	if (strchr(bigfile,'.')==NULL) {
		gprint("Error in file name,  {%s} \n",input_file);
		gle_abort("error in file name \n");
	}
	*strchr(bigfile,'.') = 0;
	strcpy(glefile,bigfile);
	strcat(glefile,".gle");
	strcat(bigfile,".big");
	gf = fopen(glefile,"r");
	if (gf==NULL) { /* then it doesn't exist, so lets create it */
		gf = fopen(glefile,"w");
		if (gf==NULL) gprint("Failed to create {%s} \n",glefile);
		else {
			fprintf(gf,"size 24 18\n");
			fprintf(gf,"bigfile %s\n",bigfile);
			fclose(gf);
		}
	} else fclose(gf);


	gf = fopen(bigfile,"w");
	if (gf==NULL) {
		gprint("Unable to open output gle file out.gle\n");
		text_inkey();
		abort();
	}
	gle_nspeed = 2;
	g_open(width,height);
}
/*---------------------------------------------------------------------------*/
v_close()
{
	g_close();
	fclose(gf);
}
/*---------------------------------------------------------------------------*/
v_lstyle(char *s)
{
	if (*s == 0) s = "1";
	vv_lstyle = DASHED_LINE;
	if (strcmp(s,"")==0) vv_lstyle = SOLID_LINE;
	if (strcmp(s,"1")==0) vv_lstyle = SOLID_LINE;
	g_set_line_style(s);
	fprintf(gf,"set lstyle %s\n",s);
}
/*---------------------------------------------------------------------------*/
v_line(float zx,float zy)
{
	g_line(zx,zy);
	fprintf(gf,"aline %g %g \n",zx,zy);
}
v_move(float zx,float zy)
{
	g_move(zx,zy);
	fprintf(gf,"amove %g %g \n",zx,zy);
}
/*---------------------------------------------------------------------------*/
v_gsave()
{
	g_gsave();
	fprintf(gf,"gsave \n");
}
v_grestore()
{
	g_grestore();
	fprintf(gf,"grestore \n");
}
v_text(char *s)
{
	g_text(s);
	fprintf(gf,"text %s \n",s);
}
double cur_hei;
v_set_hei(float g)
{
	g_set_hei(g);
	cur_hei = g;
	fprintf(gf,"set hei %g\n",g);
}
v_set_just(char *s)
{
	if (strcmp(s,"RC")==0) g_set_just(JUST_RC);
	if (strcmp(s,"TC")==0) g_set_just(JUST_TC);
	if (strcmp(s,"BC")==0) g_set_just(JUST_BC);
	if (strcmp(s,"CC")==0) g_set_just(JUST_CC);
	if (strcmp(s,"LEFT")==0) g_set_just(JUST_LEFT); 
	fprintf(gf,"set just %s\n",s);
}
v_rotate(float g)
{
	g_rotate(g);
	fprintf(gf,"rotate %g \n",g);
}
v_marker(char *m)
{
	int i;
	i = get_markeri(m);
	g_marker(i,cur_hei);
	fprintf(gf,"marker %s\n",m);
}
#include "global.h"
long gt_firstval(OPKEY lkey,char *s);
v_color(char *s)
{
  char black[10];
	int i;
	i = 0;
	if (*s == 0) {strcpy(black,"BLACK"); s = black;}
	strupr(s);
	g_set_color(gt_firstval(&op_color_typ,s));
	fprintf(gf,"set color %s\n",s);
}
long gt_firstval(OPKEY lkey,char *s)
{
	int nk,i,width=0,p;
	for (i=0; (*lkey)[i].typ!=typ_end; i++) {
		p = (*lkey)[i].pos;
		if (p>width) width = p ;
	}
	nk = i;
	for (i=0; i<nk; i++) {
		if (strcmp((*lkey)[i].name,s)==0) {
			return (*lkey)[i].idx;
		}
	}
}
get_markeri(char *s)
{
	int i;
	long f=0;
	/* if 0, maybe its a user defined marker, ie a subroutine */
	/* Use -ve to signify subroutine instead of normal marker */
	f = gt_firstval(&op_marker,s);
	return f;
}

