#define halfpi 1.57079632679489661923
#define pi 3.14159265358979323846
#include <math.h>
#include "all.h"
#ifdef VAXC 
double myatan2(double y, double x);
#endif
showpcode(long *p)
{
	union {long l; short s[2];} bth;
	int i;

	gprint("GP> ");
	for (i=0;i<4;i++) {
		bth.l = *(p++);
		gprint("%x %x  ",bth.s[0],bth.s[1]);
	}
	gprint("\n");
}
polar_xy(double r, double angle, double *dx, double *dy)
{
	*dx = r*cos(angle*3.14159265/180);
	*dy = r*sin(angle*3.14159265/180);
}
xy_polar(double dx,double dy,double *radius,double *angle)
{
	if (dx==0 && dy==0) {
		gprint("Cannot work out angle of zero length vector\n");
		return;
	}
	if (dx==0) {
		*angle = 90;
		if (dy<0) *angle = -90;
	} else {
		*angle = myatan2(dy,dx)*180/pi;
	}
	*radius = sqrt(dx*dx+dy*dy);
}
fpolar_xy(float r, float angle, float *dx, float *dy)
{
	*dx = r*cos(angle*3.14159265/180);
	*dy = r*sin(angle*3.14159265/180);
}
fxy_polar(float dx,float dy,float *radius,float *angle)
{
	if (dx==0 && dy==0) {
		gprint("Cannot work out angle of zero length vector\n");
		return;
	}
	if (dx==0) {
		*angle = 90;
		if (dy<0) *angle = -90;
	} else {
		*angle = myatan2(dy,dx)*180/pi;
	}
	*radius = sqrt(dx*dx+dy*dy);
}
ncpy(char *d, char *s, int n)
{
	strncpy(d,s,n);
	*(d+n) = 0;
}
ncat(char *d, char *s, int n)
{
	int i;
	i = strlen(d);
	strncat(d,s,n);
	*(d+i+n) = 0;
}
#ifdef VAXC 
double myatan2(double y, double x)
{
	static double one,test,xx,yy,zero,at2;
	zero = 0;
	one = 1;
	xx = fabs(x);
	yy = fabs(y);
	if (x==0) {
		at2 = halfpi;
	} else {
		if (yy<=xx) {
			at2 = fabs(atan(yy/xx));
		} else {
			test = one + (xx/yy);
			if (test!=one) {
				at2 = fabs(atan(yy/xx));
			} else {
				at2 = halfpi; 
			}
		}
		if (x<zero) at2 = pi - at2;
	} 
	if (y<0) at2 = -at2;
	return at2;
}
#else
double myatan2(double y, double x)
{
	return atan2(y,x);
}
#endif
