#define unix true
#include <stdio.h>
#ifdef ultrix
#include <cursesX.h>
#else
#include <curses.h>
#endif
#include <signal.h>
#include "vaxconio.h"
#define false 0
#define true (!false)
#define dbg if (1==1)
int iserr;
int dont_clear;
int noscreenio;
main()
{
  scr_init();
  scr_refresh();
  for (;;) {
    printw("%d ",getch());
    scr_refresh();
  }
  scr_end();
}

delay(int i)
{}
int vx_top=1,vx_bot=24;
textattr()
{}
abort_key()
{
	return false;
}
kbhit()
{
	return false;
}
scr_gets(char *x)
{
	getstr(x);
}
clreol()
{
	if (noscreenio) return;
	clrtoeol();
}
cputs(char *line)
{
	int x;
	int y;
	if (noscreenio) return;
	getyx(stdscr,y,x);
	mvaddstr(y,x,line);
}
delline()
{
	int x;
	int y;
	getyx(stdscr,y,x);
	move(22,1);
	clrtobot();
	move(y,1);
	deleteln();
	move(y,x);
}
gotoxy(int x, int y)
{
	if (noscreenio) return;
	if (y==25) y=24;
	move(y+vx_top-2,x);
}
insline()
{
	int x;
	int y;
	getyx(stdscr,y,x);
	move(y,x);
	insertln();
	move(y,x);
	move(22,1);
	clrtobot();
	move(y,x);

}
putch(int char_val)
{
	int x;
	int y;
	getyx(stdscr,y,x);
	mvaddch(y,x,char_val);
}
int scr_refresh()
{
	if (!noscreenio) refresh();
	else {printf("not refreshing, \n"); refresh();}
}
int scr_getch()
{
	if (noscreenio) return getc(stdin);
	else return getch();
}
trap(int sig)
{
	echo();
	nl();
	nocbreak();
	endwin();
	exit(sig);
}
scr_init()
{
	static int doneinit;
#ifdef ultrix
	signal(SIGINT,trap);
#endif
	if (doneinit) {printf("init called twice \n"); exit();}
	doneinit = true;
	initscr();
/*	scrollok(stdscr,true);
*/
#ifdef unix
/*	noecho();
	nonl();
	cbreak();
	clear();
	keypad(stdscr,TRUE);
*/
#endif
}
scr_end()
{
	if (noscreenio) return;
	echo();
	nl();
	nocbreak();
	endwin();
}
textbackground(int color_num)
{}
textcolor(int colornum)
{}
gettextinfo(struct text_info *r)
{
	int x;
	int y;
	if (noscreenio) return;
	getyx(stdscr,y,x);
	r->curx = x;
	r->cury = y;
	r->wintop = vx_top;
}
screen_save()
{}
screen_restore()
{
	if (noscreenio) return;
	scr_norm();
	clrscr();
	gotoxy(1,1);
	cputs("\n");
}
int wyerr;
w_message(char *s)
{
	wyerr++;
	if (noscreenio) return;
	scr_savexy();
	gotoxy(1,wyerr);
	clreol();
	cputs(s);
	scr_restorexy();
}
window(int left,int top, int right, int bottom)
{
	if (left==1 && top==1 && bottom==25) {
	if (noscreenio) return;
#ifndef unix
		printf("\x1b[%d;%dr",1,24);
#endif
	}
	vx_top = top;
	vx_bot = bottom;
	wyerr = 0;
}
clrscr()
{
	if (noscreenio) return;
	if (vx_top==1 && vx_bot==25) {
		clearok(stdscr,TRUE);
		clear();
		refresh();
		clearok(stdscr,FALSE);
		return;
	}
	clear();
}
scr_dots(int i)
{
}
scr_left(int i)
{
	int y,x;
	if (i<=0) return;
	getyx(stdscr,y,x);
	move(y,x-i);
}
scr_right(int i)
{
	int y,x;
	if (i<=0) return;
	getyx(stdscr,y,x);
	move(y,x+i);
}
int vx_topsave,vx_botsave;
int savex,savey;
scr_savexy()
{
	if (noscreenio) return;
	getyx(stdscr,savey,savex);
	vx_topsave = vx_top;
	vx_botsave = vx_bot;

}
scr_restorexy()
{
	if (noscreenio) return;
	move(savey,savex);
	vx_top = vx_topsave;
	vx_bot = vx_botsave;
}

scr_norm()  /* yellow on blue */
{
	attrset(A_NORMAL);
}
scr_inv()   /* black on white */
{
	attrset(A_BOLD);
}
scr_grey()  /* black on grey */
{
	attrset(A_REVERSE);
}
scr_isblackwhite()
{
	return true;
}
scr_menubg()
{
	scr_norm();
}
scr_menuval()
{
	scr_inv();
}
scr_menuhi()
{

	scr_grey();
}

#ifndef unix
#include <descrip.h>
vax_edt(char *s) 	/* call the vax EDT editor */
{
	$DESCRIPTOR(sdesc,"");
	sdesc.dsc$a_pointer = s;
	sdesc.dsc$w_length = strlen(s);
	edt$edit(&sdesc,&sdesc);
}
#else
vax_edt(char *s)
{}
#endif

#include "edt.h"
#define true (!false)
#define false 0
int fner(char *s);
int scr_refresh(void);
int scr_getch(void);
char *function_bar()
{
	return "F11-Help F12-Save F13-Load F14-Saveas F9-Graphmenu F10-Drawit ^x=Exit";
}

struct escape_struct {char *str; int val;};

struct escape_struct gold[] = {
		"v", 	epaste,
		"R",	esearch,
		"S",	eundeleol,
		NULL,	};

struct escape_struct eseq[] = {
		"4~", 	eselect,
		"1~",	esearch,
		"2~",	epaste,
		"3~",	ecut,
		"4~",	eselect,
		"5~",	epageup,
		"6~",	epagedown,
		"A",	eup,
		"B",	edown,
		"C",	eright,
		"D",	eleft,
		"20~",	egraphmenu,
		"21~",	edrawit,
		"23~",	ehelp,
		"24~",	esave,
		"25~",	eload,
		"26~",	esaveas,
		"P",	egold,
		"Q",	ehelp,
		"R",	efindnext,
		"S",	edeleol,
		"n",	eselect,
		"v",	ecut,
		"l",	edelright,
		NULL,	};

int gold_fn[] = {
	edrawit,ehelp,esave,eload,esaveas,eshowerror,0,0,0,egraphmenu,edrawit
};
struct keymatch {int m; int val;};
/* Normal key and ^ commands  commands */
struct keymatch kmatch2[] = {
	13, ereturn,
	3, equit,
	4, eword,
	5, eedt,
	6, efast,
	7, edrawit,
	18, eshowerror,
	8, ehelp,
	20, etrace,
	12, efindnext,
	21, eundelline,
	24, eescape,
	25, edelline,
	26, eescape,
	27, eescape,
	127, edelete,
	0,0
};
struct keymatch kmatchx[] = {
	KEY_DOWN, edown,
	KEY_UP, eup,
	KEY_F0+4, edeleol,
	KEY_LEFT, eleft,
	KEY_RIGHT, eright,
	KEY_NPAGE, epagedown,
	KEY_PPAGE, epageup,
	0,0
};
/* Control K commands */
struct keymatch kmatch3[] = {
	'b', eselect,
	'v', emove,
	'k', emark,
	'c', ecopy,
	'y', ecut,
	'u', epaste,
	'p', epaste,
	'r', eblockread,
	'w', eblockwrite,
	'm', egraphmenu,
	'l', eload,
	'd', edrawit,
	's', esave,
	'x', equit,
	0,0
};
/* Control Q commands */
struct keymatch kmatch4[] = {
	'f', esearch,
	'c', eendoffile,
	'r', etopoffile,
	0,0
};
extern int noscreenio;
tt_inkey()
{
	int i;
	if (noscreenio) return getc(stdin);
	else {
		i = getch();
		return i;
	}
}
text_inkey()
{
	int cc,i,c1,c2;

	scr_refresh();

loop1:	cc = tt_inkey();
	c2 = cc;
	if (c2==KEY_F(1)) return do_gold();
	if (cc>KEY_BREAK) {
	    for (i=0;kmatchx[i].m!=0;i++)
		if (kmatchx[i].m==c2) return kmatchx[i].val;
	}
	switch(c2) {
	  default:
	    for (i=0;kmatch2[i].m!=0;i++)
		if (kmatch2[i].m==c2) return kmatch2[i].val;
	    break;
	  case 27:
		c2 = tt_inkey(); /* throw away next char (unless escape) */
		if (c2==27) return eescape;
	  case -101:
	  case -113:
		c2 = escape_seq();
		if (c2==egold) 	return do_gold();
		return c2;
		break;
	  case 17:
	    fner("^Q  F=Find string,  R=Top of file");
	    cc = tt_inkey();
	    c2 = (cc & 0xff);
	    if (c2<32) c2 = c2 + 'a' - 1;
	    c2 = tolower(c2);
	    for (i=0;kmatch4[i].m!=0;i++)
		if (kmatch4[i].m==c2) return kmatch4[i].val;
	    fner("Unrecognized Quick movement command");
	    goto loop1;
	  case 11:
	    fner("^K  B=begin block,  P=Paste,  (use KP6 for Cut),  K=End block");
	    cc = tt_inkey();
	    c2 = (cc & 0xff);
	    if (c2<32) c2 = c2 + 'a' - 1;
	    c2 = tolower(c2);
	    for (i=0;kmatch3[i].m!=0;i++)
		if (kmatch3[i].m==c2) return kmatch3[i].val;
	    fner("Unrecognized block command");
	    goto loop1;
	}
	return c2;
}
escape_seq()
{
	int cc,i;
	unsigned char esq[10];
	char *s;

	s = &esq[0];
	*s++ = cc = tt_inkey();
	while (cc<65) *s++ = cc = tt_inkey();
	*s++ = 0;
	for (i=0;eseq[i].str!=NULL;i++)
		if (strcmp(eseq[i].str,esq)==0) break;
	if (eseq[i].str!=NULL)
		return eseq[i].val;
	else
		return 0;

}
escape_seq_gold()
{
	int cc,i;
	unsigned char esq[10];
	char *s;

	s = &esq[0];
	*s++ = cc = tt_inkey();
	while (cc<65) *s++ = cc = tt_inkey();
	*s++ = 0;
	for (i=0;gold[i].str!=NULL;i++)
		if (strcmp(gold[i].str,esq)==0) break;
	if (gold[i].str!=NULL)
		return gold[i].val;
	else
		return 0;

}

do_gold()
{
	int c2;
	c2 = tt_inkey();
	if (c2==KEY_F(4)) return eundeleol;
	if (c2==27) {
		tt_inkey();
		return escape_seq_gold();
	} else if (isdigit(c2)) {
		return gold_fn[c2-'0'];
	}
}

char *function_bar(void);
fner_clear()
{
	if (noscreenio) return;
	if (iserr==false) return;
	if (dont_clear) return;
	window(1,1,80,25);
	gotoxy(1,25);
	scr_grey();
	clreol();
	gotoxy(2,25);
	cputs(function_bar());
	scr_norm();
	iserr = false;
	window(2,3,79,23);
}
extern int noscreenio;
fner(char *s)
{
	if (dont_clear) return;
	if (noscreenio) {
		printf("%s\n",s);
		return;
	}
/*	scr_savexy();
	iserr = true;
	window(1,1,80,25);
	gotoxy(1,25);
*/	scr_inv();
	clreol();
	gotoxy(2,25);
	cputs(s);
	scr_norm();
	scr_restorexy();
	scr_refresh();
}
