#include "all.h"


/*------------------------------------------------------------------*/
/*      Find the KEY WORD *cp, and return it's number       */
/*------------------------------------------------------------------*/

/* You can add a function, you MUST place it in alphabetical order  */
/* and give it the next unused index number			    */
/*  up to 64 		*** 50 is RESERVED for assignment *** */

#define NKEYS (sizeof mkeywfn / sizeof(struct mkeyw))
struct mkeyw { char *word; int index;  } mkeywfn[] = {
	  "!",		53
	, "ALINE",	1
	, "AMOVE",	2
	, "ARC",	3
	, "ARCTO",	4
	, "Assignment", 51
	, "BEGIN", 	5
	, "BEZIER",	6
	, "BIGFILE",	58
	, "BOX",	7
	, "CALL",	52
	, "CIRCLE",	8
	, "CLOSEPATH",	9
	, "CURVE",	10
	, "DEFINE",	11
	, "DEFMARKER",	60
	, "DFONT",	12
	, "DRAW",	56
	, "ELSE",	13
	, "END",	14
	, "FCLOSE",	15
	, "FILL",	16
	, "FOPEN",	17
	, "FOR",	18
	, "FREAD",	61
	, "FREADLN",	62
	, "FWRITE",	63
	, "FWRITELN",	64
	, "GOTO",	19
	, "GRESTORE",	54
	, "GSAVE",	20
	, "ICON",	21
	, "IF",		22
	, "INCLUDE",	23
	, "INPUT", 	24
	, "JOIN",	25
	, "MARKER",	26
	, "MOVE",	27
	, "NARC",	28
	, "NEWPATH",	29
	, "NEXT",	30
	, "PIE",	31
	, "PLOTTER",	57
	, "POSTSCRIPT",	55
	, "PRINT",	32
	, "RBEZIER",	33
	, "REGION",	34
	, "RETURN",	50
	, "REVERSE",	35
	, "RLINE",	36
	, "RMOVE",	37
	, "ROT",	38
	, "ROTATE",	38
	, "SAVE",	39
	, "SCALE",	40
	, "SET",	41
	, "SIZE", 	42
	, "STROKE",	43
	, "SUB",	44
	, "TEXT",	45
	, "TEXTDEF",	59
	, "TRAN",	46
	, "TRANSLATE",	46
	, "UNTIL",	47
	, "WHILE",	48
	, "WRITE",	49
};
int binsearchk(char *word, struct mkeyw tab[], int n);

cmd_name(int idx, char **cp)
{
	int i;
	int k;
	static char *kp;
	static char fail[]="Keyword not found";
	if (kp==NULL) kp = myallocz(80);
	for (i=0;i<NKEYS;i++) {
		if (mkeywfn[i].index==idx) {
			strcpy(kp,mkeywfn[i].word);
			*cp = kp;
			return;
		}
	}
	*cp = &fail[0];
}
find_mkey(char *cp, int *idx)
{
	int i;
	i = binsearchk(cp,mkeywfn,NKEYS);
	/* printf("I %d, cmd {%s} \n",i,cp); */
	if (i==-1) { *idx = 0; return;}
	*idx = mkeywfn[i].index;
}

/*------------------------------------------------------------------*/
/* Simple binary search 					    */
/*------------------------------------------------------------------*/
binsearchk(char *word, struct mkeyw tab[], int n)
{
	int cond,low,high,mid;
	low = 0;
	high = n-1;
	while (low <= high) {
		mid = (low+high) / 2;
		if ((cond = strcmp(word,tab[mid].word)) < 0)
			high = mid - 1;
		else if (cond > 0)
			low = mid + 1;
		else
			return mid;
	}
	return -1;
}


/*-------------------------------------------------------------------------*/
/* This is for the tex primitives */

#include "tex.h"
struct mkeyw tkeywfn[] = {
 	  "^",			tp_sup
 	, "_",			tp_sub
	, "accent",		tp_accent
	, "char",		tp_char
	, "chardef",		tp_chardef
	, "def",		tp_def
	, "defbegin",		tp_defbegin
	, "delcode",		tp_delcode
	, "delimiter",		tp_delimiter
	, "frac",		tp_frac
 	, "hfill",		tp_hfill
	, "left",		tp_left
	, "linegap",		tp_linegap
	, "lineskip",		tp_lineskip
	, "mathchar",		tp_mathchar
	, "mathchardef",	tp_mathchardef
	, "mathcode",		tp_mathcode
	, "movexy",		tp_movexy
	, "newline", 		tp_newline
	, "nolimits",		tp_nolimits
	, "overbrace",		tp_overbrace
	, "overline",		tp_overline
 	, "parskip",		tp_parskip
	, "presave",		tp_presave
	, "right",		tp_right
	, "rule",		tp_rule
	, "setfont",		tp_setfont
	, "sethei",		tp_sethei
	, "setstretch",		tp_setstretch
	, "sfont",		tp_sfont
	, "ssfont",		tp_ssfont
	, "sub",		tp_sub
	, "sup",		tp_sup
	, "tfont",		tp_tfont
	, "underbrace",		tp_underbrace
	, "underline",		tp_underline
};

#define NTKEYS (sizeof tkeywfn / sizeof(struct mkeyw))
find_primcmd(char *cp)
{
	int i;
	i = binsearchk(cp,tkeywfn,NTKEYS);
	if (i==-1) return 0;
	return tkeywfn[i].index;
}












