/*----------------------------------------------------------------------*/
/* This is the font builder for GLE, it runs completely independently	*/
/* and only understands the following commands.				*/
/*1 	AMOVE x y							*/
/*2 	ALINE x y 							*/
/*3 	BEZIER x y x y x y						*/
/*4 	CLOSEPATH							*/
/*5 	FILL								*/
/*6 	STROKE								*/
/*8 	SET LWIDTH w							*/
/*7 	FILLWHITE   (no newpath )					*/
/*15	DFONT ENDCHAR 							*/
/* 	DFONT CHAR=nn  or CHAR="A" 					*/
/* 	DFONT DESIGN=v 							*/
/*----------------------------------------------------------------------*/
#define GPRINTDEF
#include "all.h"
#include <math.h>

gprint(char *s)
{
	printf("%s",s);
}

#define true (!false)
#define false 0
#define gprint printf
int debugit=false;
#define dbg if (debugit==true)
double design,gx,gy;
int thischar;
char inbuff[200],zzz[200];
char source[20];
char *tk[500];
char tkbuff[500];
unsigned char *outbuff;
int outpnt[255];
int nbig,nsmall;
int cx,cy;
int nout;
int sendp(int p);
int sendx(double x);
int sendxy(double x, double y);
int sendxyabs(double x, double y);
int sendi(int ix);
int do_line(void);

main(int argc, char **argv)
{
int ntok,f;
static char ostr[90];
double oval;
int plen,cp,otyp,i,j,endp;
int ngtxt=0;
FILE *fptr;
FILE *fout;
char *s;
char space_str[] = " ";
char fname[80];
char outfile[80];

	design = 1;
	oval = pow(2.2,3.3);
	token_equal();
	strcpy(fname,*(++argv));
        s = strchr(fname,'.');
        if (s!=NULL) *s = 0;
	strcpy(outfile,fname);
	if (strchr(fname,':')!=NULL) strcpy(outfile,strchr(fname,':')+1);
	strcat(outfile,".fve");
	strcat(fname,".gle");
	printf("Processing {%s}, creating {%s} \n",fname,outfile);
	outbuff = malloc(64000);
#ifdef unix
	fout = fopen(outfile,"w");
#else
	fout = fopen(outfile,"wb");
#endif
	if (fout==NULL) perror("Could not open output file \n");
	fptr = fopen(fname,"r");
	if (fptr==NULL) perror("Could not open input file \n");
	for (i=0;i<500;i++) tk[i] = space_str;
	for (fgets(inbuff,200,fptr);!feof(fptr);fgets(inbuff,200,fptr)) {
		i = strlen(inbuff);
/* 		printf("Source | %s",inbuff); */
		token(inbuff,(TOKENS) tk,&ntok,tkbuff);
		do_line();
	}
	printf("\n nbig %d nsmall %d nbytes %d\n\n",nbig,nsmall,nout);

/*	for (i=0;i<100;i++) if (outpnt[i]>0) dbg printf("index %d %d ",i,outpnt[i]);*/
	dbg printf("\n\n");
	dbg printf("\n nbig %d nsmall %d nbytes %d\n\n",nbig,nsmall,nout);

	for (i=0;i<100;i++) dbg printf("%d ",*(outbuff+i));
	dbg printf("\n nbig %d nsmall %d nbytes %d\n\n",nbig,nsmall,nout);


	outpnt[0] = nout;
	fwrite(outpnt,sizeof(i),256,fout);
	fwrite(outbuff,1,nout,fout);
	fclose(fout); fclose(fptr);
return 0;
}
/*--------------------------------------------------------------------------*/
#define skipspace if (*tk[ct]==' ') ct++;
do_line()
{
	int ct;

	ct = 1;
	if (strcmp(tk[ct],"ALINE")==0) 	{
		sendp(2);
		sendxy(gx=atof(tk[2]),gy=atof(tk[3]));
	} else if (strcmp(tk[ct],"RLINE")==0) 	{
		sendp(2);
		gx = gx + atof(tk[2]);
		gy = gy + atof(tk[3]);
		sendxy(gx,gy);
	} else if (strcmp(tk[ct],"RMOVE")==0) 	{
		sendp(1);
		gx = gx + atof(tk[2]);
		gy = gy + atof(tk[3]);
		sendxyabs(gx,gy);
	} else if (strcmp(tk[ct],"BEZIER")==0) {
		sendp(3);
		sendxy(atof(tk[2]),atof(tk[3]));
		sendxy(atof(tk[4]),atof(tk[5]));
		sendxy(gx=atof(tk[6]),gy=atof(tk[7]));
	} else if (strcmp(tk[ct],"AMOVE")==0) {
		sendp(1);
		sendxyabs(gx=atof(tk[2]),gy=atof(tk[3]));
	} else if (strcmp(tk[ct],"CLOSEPATH")==0) 	sendp(4);
	else if (strcmp(tk[ct],"FILL")==0) 	sendp(5);
	else if (strcmp(tk[ct],"FILLWHITE")==0) sendp(7);
	else if (strcmp(tk[ct],"STROKE")==0)	sendp(6);
	else if (strcmp(tk[ct],"\n")==0)	;
	else if (strcmp(tk[ct],"FBY")==0)	;
	else if (strcmp(tk[ct],"NEWPATH")==0)	;
	else if (strcmp(tk[ct],"\n")==0)	;
	else if (strcmp(tk[ct],"!")==0)		;
	else if (strcmp(tk[ct],"SET")==0)	{
		if (strcmp(tk[2],"LWIDTH")==0) {
			sendp(8); sendx(atof(tk[3]));
		}
	}
	else if (strcmp(tk[ct],"DFONT")==0) {
		ct+=1;
		if (strcmp(tk[ct],"DESIGN")==0)	 {
			ct++;ct++;
			design = atof(tk[ct]);
			printf("Design %g \n",design);
		} else if (strcmp(tk[ct],"CHAR")==0) {
			ct++;ct++;
			if (*tk[ct]=='"') thischar = *(tk[ct]+1);
			else thischar = atoi(tk[ct]);
			outpnt[thischar] = nout;
			dbg printf("This char %d {%s} \n",thischar,tk[ct]);
		} else if (strcmp(tk[ct],"ENDCHAR")==0) sendp(15) ;
		else if (strcmp(tk[ct],"WID")==0) ;
		else if (strcmp(tk[ct],"FBY")==0) ;
		else dbg printf("DFONT unknown command {%s} \n",tk[ct]);
	}
	else dbg printf("Unrecoginzed FONT BUILD command {%s} \n",tk[ct]);
	ct++;
}
sendp(int p)
{
	*(outbuff+nout++) = p;
}
int scl(double x);
int scl(double x)
{
 	return 1000*x/design;
}
sendxyabs(double x, double y)
{
	cx = scl(x);
	cy = scl(y);
	sendi(cx); sendi(cy);
/* 	printf("Move cx cy %d %d %g %g \n",cx,cy,x,y); */
}
sendxy(double x, double y)
{
/* 	printf("rove cx cy %d %d %d %d %g %g \n",cx,cy,scl(x),scl(y),x,y); */
	sendi(scl(x)-cx); sendi(scl(y)-cy);
	cx = scl(x);
	cy = scl(y);
}
sendi(int ix)
{
	union jjj {char a[2]; short b;} both;
/*	if (thischar=='i') printf("ix %d \n",ix);
*/
	if (ix>120 || ix <-120) {
		both.b = ix;
		*(outbuff+nout++) = 127;
		*(outbuff+nout++) = both.a[0];
		*(outbuff+nout++) = both.a[1];
		nbig++;
	} else { *(outbuff+nout++) = ix;	 nsmall++; }
}
sendx(double x)
{
	sendi(scl(x));
}

#ifdef unix
#define VAXC 1
#endif
#ifdef VAXC
char *strupr(char *s)
{
	while (*s!=0) {*s = toupper(*s); s++;}
	return s;
}
#endif
