/* this is for a   Laserjet series II printer, which I think doesn't
like the compressed data format */

#define XSIZECM 18		/* at 120 DPI  */
#define YSIZECM 24		/* at 72 DPI */
#define NXBITS 1064
#define NYBITS 1424

#include "bitmap.h"
dvitype(void)
{
	printf("Deskjet/Laserjet");
}
int ljsendline(char *s, int nc, int y);
bitmap_print(void)
{
	int x,y;
	static unsigned char out_buff[NXBITS+30];
	unsigned char swapbit[256];
	unsigned char swapnib[16]={0,8,4,12,2,10,6,14,1,9,5,13,3,11,7,15};
	unsigned char *o,c;
	int nc,i,n1,n2;

	printf("Writing out bitmap\n");
	for (i=0;i<256;i++) {
		n1 = i & 0xf;
		n2 = (i >> 4) & 0xf;
		swapbit[i] = swapnib[n2] | (swapnib[n1] << 4);
	}
	pprintf("%cE",27); 	/* reset  */
	pprintf("\x1b*t150R");	/* set resoulution 150 dpi */
	for (y=(nybits-1); y>=0; y--) {
	  o = &out_buff[0];
	  for (x=0; x<(nxbits/8) ; x++) {
		c = bitmap[y][x];
		nc = 0;
/*		for (;x<(nxbits/8-1) && bitmap[y][x+1]==c && nc<250; x++) nc++;
		*o++ = nc;
*/
		*o++ = swapbit[c];
	  }
	  ljsendline(out_buff,o-out_buff,y);
	}
	pprintf("\x0c"); /* form feed, reset origin */
}
ljsendline(char *s, int nc,int y)
{
	pprintf("\x1b&a%.1fH",0.0); /* move x */
	pprintf("\x1b&a%.1fV",((NYBITS-y)/150.0)*720.0); /* move y */
/* 	pprintf("\x1b*b1M");   compact,  not used as I think it doesn't work */
	pprintf("\x1b*r1A");	/* start graphics at cur pos */
	pprintf("\x1b*b%dW",nc);	/* send y bytes */
	printmem(s,nc);
	pprintf("\x1b*rB");		/* end grpahics */
}

