/*--------------------------------------------------------------*/
/*	DSIR P79 Driver 1.0 , for GLE V3.0			*/
/*--------------------------------------------------------------*/
#include "all.h"
#include <math.h>
#include "core.h"
#include "mygraph.h"
#include "mydev.h"
#include <descrip.h>
#define GS 29
#define FF 12
#define MAXX (400L*38L)
#define MAXY (400L*25L)
int ingraphmode;
extern struct gmodel g;
/*---------------------------------------------------------------------------*/
#define pi 3.141592653
#define true (!false)
#define BLACKANDWHITE 1
#define ESC 27
#define false 0
#define dbg if ((gle_debug & 64)>0)
#define stop if ((gle_debug & 128)>0) return
extern int gle_debug;
int incap=true;
int getch(void);
/*---------------------------------------------------------------------------*/
/* The global variables for the PC screen driver */
/*-----------------------------------------------*/

int i,l,j,ix,iy;
double f;
double devxcm,devycm;  /* settable via environment variables (or symbols*/
FILE *hpfile;

#define gerr() i = graphresult(); if (i!=0) printf("Graph error: %s \n",grapherrormsg(i));

double d_scale, d_xscale, d_yscale;
int d_graphmode;
int d_fillstyle=1,d_fillcolor;
int d_lstyle,d_lwidth;
char outstr[400];

d_devcmd(char *s)
{}
/*---------------------------------------------------------------------------*/
d_dfont(char *c)
{
	/* only used for the DFONT driver which builds fonts */
}
/*---------------------------------------------------------------------------*/
static char lastline[80];
d_message(char *s)
{
	static int single_step;
	int oldcolor,oldx,oldy;
	printf("%s\n",s);
}
/*---------------------------------------------------------------------------*/
d_source(char *s)
{
	s=s;
}
/*---------------------------------------------------------------------------*/
d_get_type(char *t)
{
	strcpy(t,"HARDCOPY, P79, VAX");
}
/*---------------------------------------------------------------------------*/
d_set_path(int onoff)
{}
/*---------------------------------------------------------------------------*/
d_newpath()
{
}
/*---------------------------------------------------------------------------*/
extern int pl2ca;
float tworld[4][4];
d_open(double width, double height)
{
	float sx,sy,xstret,ystret,ss;

	PLT00();
	MATUN(&tworld[0][0]);
	SETWM(&tworld[0][0]);
 	setpn(&1);
	sx = width;
	sy = height;
	xstret = 1;
	ystret = 1;
	if (sx<sy) xstret = sx/sy;
	if (sy<sx) ystret = sy/sx;
	SETDS2(&xstret,&ystret);
	ss = sx;
	if (sy>sx) ss = sy;
	SETSZ(&ss); /* SET SIZE */
	SETVP2(&0.0,&xstret,&0.0,&ystret);
	SETWW(&0.0,&sx,&0.0,&sy);
	plotter_fonts();
}
/*---------------------------------------------------------------------------*/
d_tidyup()
{
	d_close();
}
d_close()
{
	int a,stat;
	static $DESCRIPTOR(flse,"FALSE");
	g_flush();
	a = 18;
	SETDRV(&a,&flse,&stat);
	if ((stat&1)!=1) gprint("p79 status %d\n",stat);
	SETEJ();
}
/*---------------------------------------------------------------------------*/
d_set_line_cap(int i)
{
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_join(int i)
{
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_miterlimit(double d)
{
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_width(double w)
{
}
/*---------------------------------------------------------------------------*/
d_set_line_styled(double dd)
{}
d_set_line_style(char *s)
{
	d_lstyle = 2;
	if (strcmp(s,"")==0) d_lstyle = 1;
	if (strcmp(s,"1")==0) d_lstyle = 1;
}
/*---------------------------------------------------------------------------*/
d_fill()
{
}
/*---------------------------------------------------------------------------*/
d_fill_ary(int nwk,double (*wkx)[],double (*wky)[])
{
	int i;
/*	fprintf(psfile,"%g %g moveto \n",(*wkx)[0],(*wky)[0]);
	for (i=1;i<nwk;i++)
		fprintf(psfile,"%g %g l \n",(*wkx)[i],(*wky)[i]);
*/
}
d_line_ary(int nwk,double (*wkx)[],double (*wky)[])
{
	int i;
/*
	g_dev( (*wkx)[0], (*wky)[0], &ix, &iy);
	moveto(ix,iy);
	for (i=1;i<nwk;i++) {
		g_dev( (*wkx)[i], (*wky)[i], &ix, &iy);
		lineto(ix,iy);
	}
*/
}
/*---------------------------------------------------------------------------*/
d_stroke()
{
}
/*---------------------------------------------------------------------------*/
d_clip()
{
}
/*---------------------------------------------------------------------------*/
d_set_matrix(double newmat[3][3])
{
}
/*---------------------------------------------------------------------------*/
d_move(double zx,double zy)
{
}
/*---------------------------------------------------------------------------*/
d_reverse() 	/* reverse the order of stuff in the current path */
{
}
/*---------------------------------------------------------------------------*/
d_closepath()
{
	g_line(g.closex,g.closey);
}
/*---------------------------------------------------------------------------*/
int hpglxy(double xx, double yy);
d_line(double zx,double zy)
{
	static double ix,iy,ux,uy;
	float x,y;
	char s1[40],s2[40];
	if (g.xinline==false) {
		g_dev(g.curx,g.cury,&ux,&uy);
		x = ux; y = uy;
		MOVA2(&x,&y);
	}
	g_dev(zx,zy,&ux,&uy);
	x = ux; y = uy;
	LINA2(&x,&y);
}
/*---------------------------------------------------------------------------*/
d_clear()
{
 }
/*---------------------------------------------------------------------------*/
d_flush()
{
}
/*---------------------------------------------------------------------------*/
d_arcto(dbl x1,dbl y1,dbl x2,dbl y2,dbl rrr)
{
	df_arcto(x1,y1,x2,y2,rrr);
}
/*---------------------------------------------------------------------------*/
d_arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
	df_arc(r,t1,t2,cx,cy);
}
/*---------------------------------------------------------------------------*/
d_narc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
	df_arc(r,t1,t2,cx,cy);
}
/*---------------------------------------------------------------------------*/
d_box_fill(dbl x1, dbl y1, dbl x2, dbl y2)
{
	df_box_fill(x1,y1,x2,y2);
}
d_box_stroke(dbl x1, dbl y1, dbl x2, dbl y2)
{
	df_box_stroke(x1,y1,x2,y2);
}
/*---------------------------------------------------------------------------*/
d_circle_stroke(double zr)
{
	df_circle_stroke(zr);
}
d_circle_fill(double zr)
{
	df_circle_fill(zr);
}
/*---------------------------------------------------------------------------*/
d_bezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3)
{
	double ax,bx,cx,ay,by,cy,dist;
	double xxx,yyy,i,t,nstep,x0,y0;
	g_get_xy(&x0,&y0);
	dist = fabs(x3-x0) + fabs(y3-y0);
	nstep = 10;
	if (dist>3) nstep = 20;
	if (dist<.5) nstep = 5;
	if (dist<.3) nstep = 3;
 	if (dist<.1) {
		g_line(x3,y3);
		return;
	}
	cx = (x1-x0)*3;
	bx = (x2-x1)*3-cx;
	ax = x3-x0-cx-bx;
	cy = (y1-y0)*3;
	by = (y2-y1)*3-cy;
	ay = y3-y0-cy-by;
	for (i=0;i<=nstep;i++) {
		t = i/nstep;
		xxx = ax*pow(t,3.0) + bx*t*t + cx*t + x0;
		yyy = ay*pow(t,3.0) + by*t*t + cy*t + y0;
		g_line(xxx,yyy);
	}
}
/*---------------------------------------------------------------------------*/
d_set_color(long f)
{
	int i;
	char ss[50];
	colortyp  cc;
	cc.l = f;
	i = 1;
	if (cc.b[B_R]>100) i = 2;
	if (cc.b[B_G]>100) i = 3;
	if (cc.b[B_B]>100) i = 4;
	if (cc.b[B_B]>100 && cc.b[B_G]>100) i = 5;
	if (cc.b[B_R]>250 && cc.b[B_G]>250 && cc.b[B_B]>250) i = 6;
}
d_set_fill(long f)
{
}
/*---------------------------------------------------------------------------*/
d_beginclip()
{
}
d_endclip()
{
}
struct char_data {float wx,wy,x1,y1,x2,y2; };
int font_get_chardata(struct char_data **cd, int ff, int cc);
/*---------------------------------------------------------------------------*/
d_char(int font, int cc)
{
	static struct char_data cd;
	static int ix,iy,ix1,ix2,iy1,iy2,fz,fzx;
	static int ux,uy;
	static int safnt;
	char ss[2];

	ss[0] = cc;
	ss[1] = 0;
	if (safnt==0) safnt = pass_font("PLSR");
	if (font>=2) {
		my_char(font,cc);
		return;
	}
	my_char(safnt,cc);
}


