#include "defines.h"

static SITE_PTR *sp, sp1;

/****************************************************************/
/*	Sorting Routines
/****************************************************************/
int
xcmpsp(i,j)
int i,j;
{
    double d = X((i>=0)?sp[i]:sp1) - X((j>=0)?sp[j]:sp1);
    if ( d > 0. ) return 1;
    if ( d < 0. ) return -1;
    d = Y((i>=0)?sp[i]:sp1) - Y((j>=0)?sp[j]:sp1);
    if ( d > 0. ) return 1;
    if ( d < 0. ) return -1;
    return 0;
}

int
ycmpsp(i,j)
int i,j;
{
    double d = Y((i>=0)?sp[i]:sp1) - Y((j>=0)?sp[j]:sp1);
    if ( d > 0. ) return 1;
    if ( d < 0. ) return -1;
    d = X((i>=0)?sp[i]:sp1) - X((j>=0)?sp[j]:sp1);
    if ( d > 0. ) return 1;
    if ( d < 0. ) return -1;
    return 0;
}

int
swapsp(i,j)
int i,j;
{
    int t;
    t = (i>=0) ? sp[i] : sp1;
    if (i>=0) sp[i] = (j>=0)?sp[j]:sp1;   else sp1 = (j>=0)?sp[j]:sp1;
    if (j>=0) sp[j] = t;  else sp1 = t;
}

copysp(i,j)
int i,j;
{
    if (j>=0) sp[j] = (i>=0)?sp[i]:sp1;    else sp1 = (i>=0)?sp[i]:sp1;
}

spsortx( sp_in, low, high )
SITE_PTR *sp_in;
int low, high;
{
    sp = sp_in;
    rcssort(low,high,-1,xcmpsp,swapsp,copysp);
}

spsorty( sp_in, low, high )
SITE_PTR *sp_in;
int low, high;
{
    sp = sp_in;
    rcssort(low,high,-1,ycmpsp,swapsp,copysp);
}

#define QQ 9   /* Optimal value as determined by testing  */
#define DM 38  /*2^(1+DM/2) element sort capability. DM=38 for >10^6 elements*/

rcssort(lowelt,highelt,temp,comparison,swap,copy)
int lowelt,highelt;  /*  number of elements[low..high] to be sorted. */
int temp;  /*  element[temp] is a spare element used as working space */
int (*comparison)();  
int (*swap)();
int (*copy)();
{
int m,sij,si,sj,sL,sk;
int stack[DM];

if(highelt-lowelt<=1) return;
if(highelt-lowelt>QQ){
   m = 0;
   si = lowelt; sj = highelt;
   while(1){/* partition [si,sj] about median-of-3. */
      sij = (sj+si)/2;  /* >>1 might be faster than /2 */
      /* Now to sort elements si,sij,sj into order & set temp=their median */
      if( (*comparison)( si,sij ) > 0 ) (*swap)( si,sij );
      if( (*comparison)( sij,sj ) > 0 ){
          (*swap)( sj,sij );
          if( (*comparison)( si,sij ) > 0 ) (*swap)( si,sij );
      }
      (*copy)( sij,temp );
   
      sk = si; sL = sj;
      do{
         /* Now to partition into elements <=temp, >=temp, and ==temp. */
         do{ sL--; }while( (*comparison)( sL,temp ) > 0 );
         do{ sk++; }while( (*comparison)( temp,sk ) > 0 );
         if( sk < sL ){ (*swap)( sL,sk ); }
      }while(sk <= sL);

     /* Now to recurse on shorter partition, store longer partition on stack */
      if( sL-si > sj-sk ){
         if( sL-si < QQ ){
            if( m==0 ) break;/* empty stack && both partitions < QQ so break */
            else{ sj = stack[--m]; si  = stack[--m]; }
         }
         else{
            if( sj-sk < QQ ){ sj = sL; }
            else{ stack[m++] = si; stack[m++] = sL; si = sk; }
         }
      }
      else{
         if( sj-sk < QQ ){
            if( m==0 ) break;/* empty stack && both partitions < QQ so break */
            else{ sj = stack[--m]; si  = stack[--m]; }
         }
         else{
            if( sL-si < QQ ){ si = sk; }
            else{ stack[m++] = sk; stack[m++] = sj; sj = sL; }
         }
      }	
   }
}
/* Now for 0 or Data bounded  "straight insertion" sort of [0,nels-1]; if it is
 * known that el[-1] = -INF, then can omit the "sk>=0" test and save time. */
for(si=lowelt; si<highelt; si++){
   if( (*comparison)( si,si+1 ) > 0 ){
      (*copy)( si+1,temp ); 
      sj = sk = si; sj++;
      do{
         (*copy)( sk,sj ); sj = sk; sk--;
      }while( (*comparison)( sk,temp ) > 0 && sk>=lowelt );
      (*copy)( temp,sj );
   }
}
 return;
}/* end of rcssort() */
