#include "defines.h"

/****************************************************************/
/*	Geometric primitives
/****************************************************************/

BOOLEAN incircle(a,b,c,d)
    /* incircle, as in the Guibas-Stolfi paper. */
SITE_PTR a,b,c,d;
{
    register double adx, ady, bdx, bdy, cdx, cdy, dx, dy, nad, nbd, ncd;
    dx = X(d);	dy = Y(d);
    adx = X(a) - dx;    ady = Y(a) - dy;    
    bdx = X(b) - dx;    bdy = Y(b) - dy;    
    cdx = X(c) - dx;    cdy = Y(c) - dy;    
    nad = adx*adx+ady*ady;
    nbd = bdx*bdx+bdy*bdy;
    ncd = cdx*cdx+cdy*cdy;
    return( (0.0 <
        (  nad * (bdx * cdy - bdy * cdx)
	 + nbd * (cdx * ady - cdy * adx)
	 + ncd * (adx * bdy - ady * bdx))) ? TRUE : FALSE );
}

BOOLEAN ccw(a,b,c)
	/* TRUE iff A, B, C form a counterclockwise oriented triangle */
SITE_PTR a,b,c;
{
    return( (((X(a)-X(c))*(Y(b)-Y(c)) - (X(b)-X(c))*(Y(a)-Y(c))) > 0.0)?
    	TRUE : FALSE);
}

double angle(a,b)
	/* angle from horizontal of segment a-b */
SITE_PTR a,b;
{
    double atan2();
    return atan2(Y(b)-Y(a),X(b)-X(a));
}
