/* $Id: help.c,v 2.3 89/09/20 17:01:37 mbp Exp $
 *
 * help.c: procedures for reading and displaying help file in a window
 */

/************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips                  *
 * 									*
 * Permission to use, copy, modify, and distribute this software and    *
 * its documentation for any purpose and without fee is hereby granted, *
 * provided that the above copyright notice appear in all copies and    *
 * that both that copyright notice and this permission notice appear in *
 * supporting documentation, and that the name of Mark B. Phillips or   *
 * the University of Maryland not be used in advertising or publicity   *
 * pertaining to distribution of the software without specific, written *
 * prior permission.  This software is provided "as is" without express *
 * or implied warranty.                                                 *
 ************************************************************************/

#include <stdio.h>
#include "gr.h"
#include "internal.h"

/* Help subframe has one panel and one text subwindow for displaying
 * help page */
Frame	GR_help_frame = NULL;
Panel	GR_help_panel = NULL;
Textsw	GR_help_textsw = NULL;

/* Gadgets for help panel: */
static Panel_item help_done_button;

/* Notification procedure for button in help panel: */
static int help_done_button_proc();

/* Name of file to display in help window */
#define HELP_FILE_NAME_LENGTH 256
static char help_file[HELP_FILE_NAME_LENGTH+1];
static int help_file_specified=0;

/*-----------------------------------------------------------------------
 * Function:    GR_display_help_window
 * Description: display the help window
 * Args:	(none)
 * Returns:     0 for success, 1 for failure
 * Notes:       The file is read and the window created on the first
 *		call.  After that, we just redisplay the
 *		already-created window.
 */
GR_display_help_window()
{
  char msg[GR_ERROR_MESSAGE_LENGTH+1];

  /* If the help frame hasn't been created yet, create it */
  if (GR_help_frame==NULL) {

    if (!help_file_specified)
      construct_help_file_name(help_file);

    if (!GR_file_openable(help_file, "r")) {
      sprintf(msg,"I can't find help file \"%s\" !", help_file);
      GR_error(msg);
      return(1);
    }

    GR_help_frame =
      window_create(GR_base_frame, FRAME,
		    WIN_FONT, GR_regular_font,
		    FRAME_LABEL, "Help Window",
		    FRAME_SHOW_LABEL, TRUE,
		    WIN_X, 206,
		    WIN_Y, 169,
		    0);
    if (GR_help_frame == NULL) {
      GR_error("Cannot open any more windows !");
      return(1);
      }

    GR_help_panel =
      window_create(GR_help_frame, PANEL,
		    WIN_X, 0,
		    WIN_Y, 3,
		    WIN_HEIGHT,	ATTR_ROW(1)+4,
		    WIN_FONT, GR_regular_font,
		    0);
    if (GR_help_panel == NULL) {
      GR_error("Cannot open any more windows !");
      window_destroy(GR_help_frame);
      GR_help_frame = NULL;
      return(1);
      }

    help_done_button = 
      panel_create_item(GR_help_panel, PANEL_BUTTON, 
			PANEL_ITEM_X, ATTR_COL(0),
			PANEL_ITEM_Y, ATTR_ROW(0),
			PANEL_LABEL_IMAGE,
			  panel_button_image(GR_help_panel, "Done", 3, 0),
			PANEL_NOTIFY_PROC, help_done_button_proc,
			0);

    GR_help_textsw =
      window_create(GR_help_frame, TEXTSW,
		    WIN_ERROR_MSG, "I can'tfind the help file !",
		    WIN_FONT,		    pf_default(),
		    WIN_X,                  0,
		    WIN_Y,		    ATTR_ROW(2)+5,
		    WIN_HEIGHT,             ATTR_ROW(30),
		    WIN_WIDTH,              ATTR_COL(78),
		    TEXTSW_IGNORE_LIMIT,    TEXTSW_INFINITY,
		    TEXTSW_AUTO_INDENT,     TRUE,
		    TEXTSW_BROWSING,        TRUE,
		    TEXTSW_DISABLE_LOAD,    TRUE,
		    TEXTSW_DISABLE_CD,      TRUE,
		    TEXTSW_FILE,    	help_file,
		    0);
    if (GR_help_textsw == NULL) {
      GR_error("I can't create the help page");
      window_destroy(GR_help_frame);
      GR_help_frame = NULL;
      return(1);
      }

    window_fit(GR_help_frame);
    GR_register_interposer(GR_help_frame);

  }  /* end of "if (GR_help_frame==NULL) ..." */

  /* Now display the help frame */
  if (GR_help_frame!=NULL) {
    window_set(GR_help_frame, WIN_SHOW, TRUE, 0);
    return(0);
  }
  else
    return(1);
}

/*-----------------------------------------------------------------------
 * Function:	GR_set_help_file
 * Description:	specify the name of the file to display in the help window
 * Args  IN:	filename: the file's name
 * Notes:	This does not change the visibility status of the
 *		help window
 */
GR_set_help_file(filename)
char *filename;
{
  char msg[GR_ERROR_MESSAGE_LENGTH+1];

  if (filename == NULL) return(1);

  if (strlen(filename) > HELP_FILE_NAME_LENGTH) {
    GR_error("Your help file name is tooooo looooooooooonnnnnnnnnggggg !!");
    return(1);
  }

  strcpy(help_file, filename);
  help_file_specified = 1;

  /* If the help window has been created, load the new file */
  if (GR_help_textsw != NULL) {
    if (!GR_file_openable(help_file, "r")) {
      sprintf(msg,"I can't find help file \"%s\" !", help_file);
      GR_error(msg);
      return(1);
    }
    else
      window_set(GR_help_textsw, TEXTSW_FILE, help_file, 0);
  }

  return(0);
}

static int
help_done_button_proc()
{
  window_set(GR_help_frame, WIN_SHOW, FALSE, 0);
}

static
  construct_help_file_name(fname)
char *fname;
{
  extern char *getenv();
  char *gr_lib;

  /* First look in GR_LIB */
  gr_lib = getenv("GR_LIB");
  if (gr_lib != NULL) {
    sprintf(fname,"%s%s%s",
	    gr_lib, (gr_lib[strlen(gr_lib)-1]=='/') ? "" : "/",
	    "gr.help");
    if (GR_file_openable(fname, "r")) return;
  }

  /* If not there, then use default */
  strcpy(fname, DEFAULT_HELP_FILE);
}
