/* Copyright 1988 John M. Sullivan.  See main program for details. */
#include "vcs.h"
#define l_dot(a,b) n_dot((real *)(a),(real *)(b),&NNN)
#define l_copy(a,b) n_copy((real *)(a),(real *)(b),NNN)
#define l_divide(a,x) n_divide((real *)(a),(real)(x),NNN)
#define l_dot_after_sub_mult(a,x,b,c)	\
    n_dot_after_sub_mult((real *)(a),&(x),(real *)(b),(real *)(c),&NNN)

#define DPNDNT 1e-8
#define SMALLVECT (1./50)

/****  			Orthnew                     ***/
/**** Computes the orthogonal complement of the area gradient ***/
/**** to the space spanned by K volume gradients	      ***/  

real n_dot_after_sub_mult(),n_dot();
void n_divide(),n_copy();

real
proj(vec,i)
real *vec;
int i;
{
    real coeff;
    int NNN = 3*N_Pos_Sites;
    int j;

    coeff = l_dot(vec,Gradients[1]);
    for (j = 1; j < i; j++)
	coeff = l_dot_after_sub_mult(vec,coeff,Gradients[j],Gradients[j+1]);
/* if Gr[j] is small (ignored) we could omit one step, but would be messy */

    if (i)
	coeff = l_dot_after_sub_mult(vec,coeff,Gradients[i],vec);
    else
	coeff = l_dot(vec,vec);

#ifdef CRAY
    if (i)
	coeff = l_dot(vec,vec);
/* since above doesn't work with vectorization */
#endif

    return coeff;
}


void
orth_proj(sm)
real sm;
{
/***  Compute orthonormal basis for volume gradient vectors ***/

    int depnd = 0;
    int small = 0;
    clr i,j;
    site s;
    real coeff;
    int NNN = 3*N_Pos_Sites;
    real *gi,*gi1;
    real beta;

    if (sizeof(struct point) != 3*sizeof(real))
	error("Internal: points not stored as expected");

    for (i = 1; i <= Max_color; i++)
    {
	gi = (real *) Gradients[i];
	gi1 = (real *) Gradients[i<Max_color? i+1 : i];
	/* for i==Max_color this is just random thing to avoid segflt */

	coeff = proj(gi,i-1);
	if (coeff < DPNDNT)	/* if vector dpndt on prev*/
	{
	    beta = l_dot(Motion, gi1);
	    depnd++;
	}
	else
	{
	    if (i==1)
		beta = l_dot(Motion,gi); /* Not 0 if Jump flag on */
	    coeff = sqrt(coeff);
	    l_divide(gi,coeff);
/********************************************************************
****** line above replaces this loop:
for_moving_sites(s) vol_grad(i,s)->x /= coeff, ...y..., ...z...;
***** Next we want to do:
beta = (desired[i] - dot(motion,true))/dot(gi,true);
motion += beta*gi;
where true is the original gi before we applied Gr-Schm
But dot(gi,true) is then sqrt(dot(gi,gi))=coeff.
And dot(motion,true) was calculated last time through the loop.
*********************************************************************/
	    if (coeff > sm)
		beta = (beta - Desired_Changes[i]) / coeff;
	    else
		small++, beta = 0;
	    beta = l_dot_after_sub_mult(Motion,beta,gi,gi1);
	}
    }
    if (depnd)
	warning("There were %d non-independent volume gradients",depnd);
    if (small)
	warning("There were %d ignored small volume gradients",small);
}

proj_motion(vec,red,mx) /* expect vec will be Area_Grad or Wulff_Grad */
point vec;
real red;
real mx;
{
    real *gi = (real *)vec;
    real coeff,beta;
    int NNN = 3*N_Pos_Sites;

    coeff = proj(gi,Max_color);
    if (coeff < DPNDNT)
	warning("Area gradient not independent of volume gradients");
    else
    {
	coeff = sqrt(coeff);
	l_divide(gi,coeff);
	beta = coeff/red;
	beta = l_dot_after_sub_mult(Motion,beta,gi,Motion);
	/* just subtracts vec/red from Motion; coeff really ignored */
    }
#ifdef CRAY
	beta = l_dot(Motion,Motion);
/* because last step above doesn't work with vectorization */
#endif
    if (beta > mx*N_Pos_Sites)
    {
	beta = sqrt(beta/(mx*N_Pos_Sites));
	l_divide(Motion, beta);
	warning("Reducing desired motion by a factor of %f",beta);
    }
}

void
n_divide(a,x,n)
register real *a,x;
register int n;
{
    register int m;

    for(m=n; m; --m)
	*a++ /= x;
}

void
n_copy(a,b,n)
register real *a,*b;
register int n;
{
    register int m;

    for(m=n; m; --m)
	*a++ = *b++;
}
