/* first3.c */
/* Copyright 1988 John M. Sullivan.  See main program for details. */
/*** get initial delauney triangle ***/

#include "vcs.h"

/***** External functions
facet_edge first_three(): Gets the first triangle
*****/

facet_edge
first_three()
/* Find some triangle on the edge of the convex hull of the sites */
/* We do this by finding the point of min x, then the point of min xy
    slope from the first, then the third point such that all volumes
    s1,s2,s3,x are positive */
{
    register site s;
    register site s1,s2,s3;
    real slope,newslope;
    real vol;
    bool tied;

    s1 = Sites;
    for_sites(s)
	if  (s->loc->x < s1->loc->x
	 || (s->loc->x == s1->loc->x
		     && (s->loc->y > s1->loc->y
		     || (s->loc->y == s1->loc->y && s->loc->z < s1->loc->z))))
	    s1 = s;

    slope = HUGE;
    for_sites(s)
    {
	if (s==s1) continue;
	if (s->loc->x == s1->loc->x)
	{
	    warning("tied min x values");
	    newslope = -HUGE, tied = FALSE;
	    if (newslope < slope || s->loc->y < s2->loc->y)
		s2 = s, slope = newslope;
	}
	else
	{
	    newslope = (s->loc->y - s1->loc->y)/(s->loc->x - s1->loc->x);
	    if (newslope < slope)
		s2 = s, slope = newslope, tied = FALSE;
	    else if (newslope == slope)
		tied = TRUE;
	}
    }
    if (tied)
	warning("tied minimum xy slope values");

    s3 = Sites;
    while (area2(s1->loc,s2->loc,s3->loc) == 0.)
	s3++;
    for_sites(s)
	if (s == s1 || s==s2 || s==s3)
	    continue;
	else if ((vol = volume(s1->loc,s2->loc,s3->loc,s->loc)) < 0.)
	    s3 = s, tied = FALSE;
	else if (vol == 0.)
	    tied = TRUE;
    if (tied)
	warning("four points in plane of first triangle");

    return s2->one_fe =
	    (s1->one_fe = s3->one_fe = make_wing(s1,s2,s3))->nextfacet;
}
