        SUBROUTINE NNSC
     *     (N, R, C, IL, JL, IJL, L, D, IU, JU, IJU, U, Z, B, TMP)        CD1000
C                                                                         CD1001
C       INPUT VARIABLES:   N, R, C, IL, JL, IJL, L, D, IU, JU, IJU, U, B  CD1002
C       OUTPUT VARIABLES:  Z                                              CD1003
C                                                                         CD1004
C       PARAMETERS USED INTERNALLY:                                       CD1005
C FIA   \ TMP   - TEMPORARY VECTOR WHICH GETS RESULT OF SOLVING  LY = B.  CD1006
C       \           SIZE = N.                                             CD1007
C                                                                         CD1008
C  INTERNAL VARIABLES:                                                    CD1009
C    JMIN, JMAX - INDICES OF THE FIRST AND LAST POSITIONS IN A ROW OF     CD1010
C      U OR L  TO BE USED.                                                CD1011
C                                                                         CD1012
        INTEGER R(1), C(1), IL(1), JL(1), IJL(1), IU(1), JU(1), IJU(1)    CD1013
C       REAL L(1), D(1), U(1), B(1), Z(1), TMP(1), TMPK, SUM              CD1014
        DOUBLE PRECISION  L(1), D(1), U(1), B(1), Z(1), TMP(1), TMPK,SUM  CD1015
C                                                                         CD1016
C  ******  SET TMP TO REORDERED B  *************************************  CD1017
        DO 1 K=1,N                                                        CD1018
   1      TMP(K) = B(R(K))                                                CD1019
C  ******  SOLVE  LY = B  BY FORWARD SUBSTITUTION  *********************  CD1020
        DO 3 K=1,N                                                        CD1021
          JMIN = IL(K)                                                    CD1022
          JMAX = IL(K+1) - 1                                              CD1023
          TMPK = -D(K) * TMP(K)                                           CD1024
          TMP(K) = -TMPK                                                  CD1025
          IF (JMIN .GT. JMAX) GO TO 3                                     CD1026
          ML = IJL(K) - JMIN                                              CD1027
          DO 2 J=JMIN,JMAX                                                CD1028
   2        TMP(JL(ML+J)) = TMP(JL(ML+J)) + TMPK * L(J)                   CD1029
   3      CONTINUE                                                        CD1030
C  ******  SOLVE  UX = Y  BY BACK SUBSTITUTION  ************************  CD1031
        K = N                                                             CD1032
        DO 6 I=1,N                                                        CD1033
          SUM = -TMP(K)                                                   CD1034
          JMIN = IU(K)                                                    CD1035
          JMAX = IU(K+1) - 1                                              CD1036
          IF (JMIN .GT. JMAX) GO TO 5                                     CD1037
          MU = IJU(K) - JMIN                                              CD1038
          DO 4 J=JMIN,JMAX                                                CD1039
   4        SUM = SUM + U(J) * TMP(JU(MU+J))                              CD1040
   5      TMP(K) = -SUM                                                   CD1041
          Z(C(K)) = -SUM                                                  CD1042
          K = K - 1                                                       CD1043
   6      CONTINUE                                                        CD1044
        RETURN                                                            CD1045
        END                                                               CD1046
