/* The main module for box */

#include <stdio.h>
#include <X11/Xlib.h>
#include "box_types.h"

Display *dpy;
double xppmm,yppmm;  /* x and y pixels per millimeter */
double WidthMM,HeightMM;

BoxStatus box_status;
BoxData box_data;

main(argc,argv)

int argc;
char *argv[];

{
  Window top;
  XWindowAttributes xwa;
  XEvent event;

  /* Open up the connection to the X Server */

  if((dpy = XOpenDisplay(NULL)) == NULL) {
    fprintf(stderr,"Could not open server.\n");
    exit(1);
   }

  /* Get some basic information */

  WidthMM = (double) DisplayWidthMM(dpy,DefaultScreen(dpy));
  HeightMM = (double) DisplayHeightMM(dpy,DefaultScreen(dpy));
  xppmm = (double) DisplayWidth(dpy,DefaultScreen(dpy))/WidthMM;
  yppmm = (double) DisplayHeight(dpy,DefaultScreen(dpy))/HeightMM;


  /* initialize client */
  BoxSetUp(&box_data);
  BoxInitialize(&box_status,&box_data);

  while(1){

     XNextEvent(dpy,&event);
     top = event.xany.window;
     if(top == box_status.TopWindow ||
          top == box_status.MessageWindow ||
          top == box_status.TitleWindow) {

        BoxEvent(&box_status,&event);

        /* Check it out */
        if(BoxStateChange((VOID *) (&box_status))) {
           int choice[10],num;
           num = ExtractBoxSelection((VOID *) (&box_status),
                                         choice);
           /* Normally a client's menu handler will go here. */
           /* e.g. *MenuChoice(gnrc,num,choice) */
          }
        continue;
       }
    }
}

BoxSetUp(data)
BoxData *data;

{

  data->root = DefaultRootWindow(dpy);
  data->x =  BOX_X_OFFSET * WidthMM;
  data->y = BOX_Y_OFFSET * HeightMM;
  data->width = 252.21; 
  data->height = 235.37; 
  data->border = BOX_BORDER;

  data->title_present = BOX_NO;
  data->message_present = BOX_NO;
  data->urgent_present = BOX_NO;
  data->do_not_map = BOX_NO;

  strcpy(data->title,"Wave Editor");
  strcpy(data->message,"Let's make waves.");
  strcpy(data->font,"9x15");

  data->arg = (VOID *) NULL;

}
