#include <stdio.h>
#include <X11/Xlib.h>
#include "box_types.h"
#include "box_global.h"


BoxButtonPress(gnrc,event)

BoxStatus *gnrc;
XEvent *event;

{
  BoxList *bx;
  int x,y,x1,y1;
  XEvent evnt;

  x = event->xbutton.x;
  y = event->xbutton.y;

  bx = FindBoxByPosition(gnrc,x,y);

  /* Check if valid choice of box */
  if(bx == &(gnrc->box)) {
    switch(gnrc->current_box->type) {

       case BOX_MENU:  /* Ok to erase display to initial setting */
         BoxReset(gnrc); 
         break;

       default: /* better not do anything drastic */
         BoxPrintMessage(gnrc,"Current selection must be completed.");
         break;
      }
    return(-1); 
   }

  /* modify sliders-  need to use x,y coordinates */
  /* Probably better to use XQueryPointer and do this in BoxSelect */
  switch(bx->type) {
      
     case BOX_HORIZONTAL_SLIDER:
       BoxPrintMessage(gnrc,"Slider Chosen.");
       gnrc->current_box = bx;
       /* Compute new value */
       bx ->value = (double) (x - bx->x) / (double) bx->width;
       DrawBox(gnrc,bx);
       break;

     case BOX_VERTICAL_SLIDER:
       BoxPrintMessage(gnrc,"Slider Chosen.");
       gnrc->current_box = bx;
       /* Compute new value */
       bx ->value = 1.0 - (double) (y - bx->y) / (double) bx->height;
       DrawBox(gnrc,bx);
       break;
    }
  /* Do continuous callbacks */
  switch(bx->type) {  /* Text entry is special */

     case BOX_TEXT_ENTRY:
       break;

     default:
       if(bx->continuous_local_callback != NULL ||
                 bx->continuous_global_callback != NULL) {
          while(1) {

              if(XCheckMaskEvent(dpy,ButtonReleaseMask,&evnt)) break;

              if(bx->continuous_local_callback != NULL) {
                    (*(bx->continuous_local_callback))(gnrc,bx);
                }
              if(bx->continuous_global_callback != NULL) {
                 if(bx->global_arg != NULL)
                    (*(bx->continuous_global_callback))(bx->global_arg,
                                             (VOID *)gnrc,bx->id);

                 else
                    (*(bx->continuous_global_callback))(gnrc->arg,(VOID *)gnrc,
                                             bx->id);
                }
             }
          }
        break;
     }
  /* React to being selected */
  BoxSelect(gnrc,bx);
}

BoxCleanup(gnrc,bx)

BoxStatus *gnrc;
BoxList *bx;

/* Routine cleans up the display after a box with the cleanup flag is */
/* activated.  The cleanup goes to the top level or until a box with */
/* the stop cleanup flag is set */

{
  BoxList *parent,*child;

     parent = bx->parent;
     if(bx->always_visible == BOX_YES || parent == &(gnrc->box)) { 
        /* No serious cleanup necessary */
        BoxCleanupState(gnrc,bx);
        DrawBox(gnrc,bx);
        gnrc->current_box = &(gnrc->box);
        return(0);
       }
     while(parent->parent != &(gnrc->box) && parent->stop_cleanup != BOX_YES) { 
        parent->visible = BOX_NO;
        BoxCleanupState(gnrc,parent);
        child = parent->child;
        while(child != NULL) {
           child->visible = BOX_NO; 
           BoxCleanupState(gnrc,child);
           DrawBox(gnrc,child);
           child = child->sibling;
          }
        DrawBox(gnrc,parent);
        parent = parent->parent;
       }
     BoxCleanupState(gnrc,parent);
     child = parent->child;  /* children of last parent missed above */
     while(child != NULL) {
        child->visible = BOX_NO; 
        BoxCleanupState(gnrc,child);
        DrawBox(gnrc,child);
        child = child->sibling;
       }

     gnrc->current_box = parent->parent;
     XClearWindow(dpy,gnrc->TopWindow);
     ReDrawBoxTopWindow(gnrc);
}

BoxCleanupState(gnrc,bx)

BoxStatus *gnrc;
BoxList *bx;     /* What to do with a box's state on cleanup */

{
  switch(bx->type) {
     case BOX_MENU:
     case BOX_TEXT_ENTRY:
       bx->state = BOX_NO;
       break;
    }
}

BoxFlashTime()

{
  int i;
  for(i=0;i<BOX_FLASH_COUNT;++i);
}

BoxIsValidChoice(gnrc,bx)

BoxStatus *gnrc;
BoxList *bx;

{
  int valid;
  valid = 1;
  switch(gnrc->current_box->type) {
     case BOX_MENU:
       if(!BoxIsADescendent(gnrc,bx,gnrc->current_box)) valid = 0;
       break;
     case BOX_TOGGLE:
     case BOX_TEXT_ENTRY:
     case BOX_HORIZONTAL_SLIDER:
     case BOX_VERTICAL_SLIDER:
       if(!BoxIsADescendent(gnrc,bx,gnrc->current_box)
             && !BoxIsASibling(gnrc,bx,gnrc->current_box))  valid = 0;
       break;
    }

  return(valid);
}

BoxSelect(gnrc,bx)

BoxStatus *gnrc;
BoxList *bx;

/* How a box reacts to being selected.  Note that slider repositioning */
/* must occur prior to this call */
/* Also, continuous callbacks, since they involve mouse or key events */
{
  BoxList *child,*parent;

  switch(bx->type) {
      
     case BOX_MENU:
       BoxPrintMessage(gnrc,"Menu Chosen.");
       gnrc->current_box = bx;
       bx->state = BOX_YES;
       DrawBox(gnrc,bx);
       /* if last menu in cascade just flash it */
       if(bx->child == NULL) {
          BoxFlashTime();
          bx->state = BOX_NO; DrawBox(gnrc,bx);
         }
       break;

     case BOX_TOGGLE:
       BoxPrintMessage(gnrc,"Toggle Chosen.");
       if(BoxIsASibling(gnrc,bx,gnrc->current_box) &&
                   gnrc->current_box->type != BOX_TOGGLE) {
          gnrc->current_box->state = BOX_NO;
          DrawBox(gnrc,gnrc->current_box);
         }
       gnrc->current_box = bx;
       if(bx->state == BOX_YES) { bx->state = BOX_NO; DrawBox(gnrc,bx); }
       else {
          bx->state = BOX_YES; DrawBox(gnrc,bx);
          /* check exclusive flag of parent */
          parent = bx->parent;
          if(parent->exclusive == BOX_YES) {
             child = parent->child;
             while(child != NULL) {
                 if(child->state == BOX_YES && child != bx && 
                      child->type == BOX_TOGGLE) {
                    child->state = BOX_NO; DrawBox(gnrc,child);
                   }
                 child = child->sibling;
                }
            }
         }
       break;

     case BOX_TEXT_ENTRY:
       BoxPrintMessage(gnrc,"Text Entry Chosen.");
       if(BoxIsASibling(gnrc,bx,gnrc->current_box) &&
                   gnrc->current_box->type != BOX_TOGGLE) {
          gnrc->current_box->state = BOX_NO;
          DrawBox(gnrc,gnrc->current_box);
         }
       gnrc->current_box = bx; 
       bx->state = BOX_YES; DrawBox(gnrc,bx);
       break;

     case BOX_HORIZONTAL_SLIDER:
     case BOX_VERTICAL_SLIDER:
       break;

     default:
       fprintf(stderr,"Unknown type of box.\n");
       break;
    }
  /* Do callbacks : note text entry callbacks done on 'return'*/
  switch(bx->type) {

    case BOX_TEXT_ENTRY:
      break;

    default:

      if(bx->local_callback != NULL) {
         (*(bx->local_callback))(gnrc,bx);
        }
      if(bx->global_callback != NULL) {
         /* if bx has global_arg use it, otherwise use gnrc->arg */
         if(bx->global_arg != NULL) {
            (*(bx->global_callback))(bx->global_arg,(VOID *)gnrc,bx->id);
           }
         else {
            (*(bx->global_callback))(gnrc->arg,(VOID *)gnrc,bx->id);
           }
        }

      break;
    }
  /* Post selection processing */

  switch(bx->type) {
     case BOX_TOGGLE:
     case BOX_MENU:
     case BOX_HORIZONTAL_SLIDER:
     case BOX_VERTICAL_SLIDER:
       /* draw children */
       child = bx->child;
       while(child != NULL) {
          child->visible = BOX_YES; DrawBox(gnrc,child);
          child = child->sibling;
         }

       if(bx->induce_state_change == BOX_YES) {
          gnrc->state_change = BOX_YES;
          gnrc->select_box = bx;
         }
       if(bx->cleanup == BOX_YES)  BoxCleanup(gnrc,bx);
       break;

     case BOX_TEXT_ENTRY:
       /* This is done within the BoxTextEntryKey routine when 'return' */
       /* is pressed */
       break;
    }
}

BoxReset(gnrc)

BoxStatus *gnrc;

{
  BoxList *bx;

  gnrc->current_box = &(gnrc->box);
  bx = gnrc->box.next;
  while(bx != NULL) {
     if(bx->parent != &(gnrc->box)) bx->visible = BOX_NO;
     switch(bx->type) {
        case BOX_MENU:
          bx->state = BOX_NO;
          break;
       }
     bx = bx->next;
    }
  XClearWindow(dpy,gnrc->TopWindow);
  ReDrawBoxTopWindow(gnrc);
}

