/*
Initialize all parameters for a given dynamical system to be installed
Parameters are assigned to the default values before this program is called.
-----------------------------------------------------------------------
This is a GENERIC subroutine. If you want, you can change
the name string "userds2" to a proper one globally in this program
but then you need to change the same strings in the header file defining
the current class of dynamical systems.
*/

/*
Example 1: vector field with no periodic variable
*/
#include "model.h"

int userds2_init()
{
	/* title label */
	title_label = "Meanders of the Ardenne";

	/* mapping toggle: 1: map, 0: vector field */
	mapping_on = 1;
	/* inverse toggle: vector field: always 1,
	   maps: 1=explicit inverse is defined, 0=otherwise  */    /*  mrm (2/6/90)   */
	inverse_on = 1;
	/* jacobian toggle: 1=Jacobian is explicitly given, 0=otherwise */
	fderiv_on = 0;
	/* polar toggle: 1=enable polar coordinate feature, 0=otherwise */
	enable_polar = 0;
	/* period toggle: 1=enable periodicity of phase space, 0=otherwise */
	enable_period = 1;

	/* phase space dimension */
	var_dim = 2;
	/* parameter space dimension */
	param_dim = 3;
	/* function space dimension */
	func_dim = 2;

	(void) malloc_init();

	/*periodicity of phase space variables (DIM=var_dim)*/
	/* do not have to be defined if enable_period = 0 */
	period_len[0] =1;
	period_len[1] =1;

	/* primary phase space variable label (DIM=var_dim)*/
	var_label[0] = "x";
	var_label[1] = "y";
	/* parameter variable label (DIM=param_dim)*/
	param_label[0] = "alpha";
	param_label[1] = "beta";
	param_label[2] = "k";
	/* function variable label (DIM=func_dim)*/
	func_label[0] = "Undefined";
	func_label[1] = "Undefined";

	/* starting parameter values (DIM=param_dim)*/
	param[0] = 1.5;
	param[1] = -.85;
	param[2] = 1.0;

	/* starting primary phase space variable values (DIM=param_dim)*/
	var_i[0] = 0;
	var_i[1] = 0;

	/* starting bounds of parameter window box */
	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;

	/* starting bounds of primary phase space window box */
	var_min[0]= 0; var_max[0]= 1;
	var_min[1]= 0; var_max[1]= 1;

	/* dynamical system and function pointer assignments */
	f_p = userds2_f;
	func_p = userds2_func;
}
/*
third user dynamical system 
*/
	
int userds2_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double sin(),cos();
	extern double pi;

	if(index ==1) {
		f[1] = x[1] - p[2] / (2 * pi) * sin(2 * pi * x[0]);
		f[0] = x[0] + p[1] + p[0] / (2 * pi) * cos(2 * pi * f[1]);
	}
	/* define an inverse if you have time */
}
/*
third user function subroutine
*/

int userds2_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	f[0] = 0;
	f[1] = 0;
}
