/*
### show colormap strips ###

Note:	# of bands in each strip = colormap_max_bands,
	Maximum of upto 2 strips
*/

#include <suntool/sunview.h>

show_colormap()
{
	int             i, ix, iy;
	char            s[3];
	extern short param_window_show;
	extern int colormap_strip_on,slide_mode;
	extern int colormap_height,colormap_width,colormap_spacing,colormap_max_bands;
	extern int l_margin,b_margin,ycanvas,ywidth,my_colormap_size;
	extern int p_l_margin,p_b_margin,p_ycanvas,p_ywidth;
	extern Pixwin *pw,*param_pw;
	extern Pixfont *courier10;

	if(!colormap_strip_on)
		return;

	/* allow only  two strips of colormap bands */

	if(slide_mode){
		ix = l_margin;
		iy = ycanvas - (b_margin + ywidth + 2 * (colormap_height + colormap_spacing));
		for (i = 0; i < my_colormap_size; i++) {
			pw_rop(pw, ix, iy+1 , colormap_width-1, colormap_height, PIX_SRC | PIX_COLOR(i), (Pixrect *) 0, 0, 0);
			ix += colormap_width;
		}
		if(param_window_show){
			ix = p_l_margin;
			iy = p_ycanvas - (p_b_margin + p_ywidth + 2 * (colormap_height + colormap_spacing));
			for (i = 0; i < my_colormap_size; i++) {
				pw_rop(param_pw, ix, iy+1 , colormap_width-1, colormap_height, PIX_SRC | PIX_COLOR(i), (Pixrect *) 0, 0, 0);
				ix += colormap_width;
			}
		}
	}
	else {
		ix = l_margin;
		iy = ycanvas - (b_margin + ywidth + 2 * (colormap_height + colormap_spacing));
		for (i = 0; i < my_colormap_size; i++) {
			/* write every 25th elements */
			if (i % 25 == 0) {
				sprintf(s, "%d", i);
				pw_text(pw, ix-1, iy, PIX_SRC | PIX_COLOR(i), courier10, s);
			}
			pw_rop(pw, ix, iy+1 , colormap_width-1, colormap_height, PIX_SRC | PIX_COLOR(i), (Pixrect *) 0, 0, 0);
			ix += colormap_width;

			/* the maximum number of colormap bands on a line
			is colormap_max_bands*/
			if (i  == colormap_max_bands-1){
				ix = l_margin;
				iy += colormap_height + colormap_spacing;
			}
		}
	}
}
