/*
### reallocate memory for main data variables as necessary ###
*/

#include <stdio.h>

double **realloc_main_data(mdim,ndim)
int mdim,ndim;
{
	int i,*vt;
	double **mt;
	extern int stop,region_index;
	extern int *data0_color,*data1_color,*data2_color;
	extern double **data0_x,**data1_x,**data2_x;

	/* reallocate memory for color */
	switch(region_index){
		case 0: vt = (int *) realloc(data0_color,(unsigned) mdim * sizeof(int));
			break;
		case 1: vt = (int *) realloc(data1_color,(unsigned) mdim * sizeof(int));
			break;
		case 2: vt = (int *) realloc(data2_color,(unsigned) mdim * sizeof(int));
			break;
		default:
			break;
	}
	if (!vt){
		system_mess_proc(1,"realloc_memory: color allocation failure!");
		stop = 1;
		return;
	}
	switch(region_index){
		case 0:	data0_color = vt; 
			break;
		case 1: data1_color = vt;
			break;
		case 2: data2_color = vt;
			break;
		default:
			break;
	}
	
	mt = (double **) malloc((unsigned) sizeof(double *) * ndim);
	/* reallocate memory for coords */
	for(i=0;i<ndim;i++){
		switch(region_index){
			case 0: 
				mt[i] = (double *) realloc(data0_x[i],(unsigned) sizeof(double) * mdim);
				break;
			case 1: 
				mt[i] = (double *) realloc(data1_x[i],(unsigned) sizeof(double) * mdim);
				break;
			case 2: 
				mt[i] = (double *) realloc(data2_x[i],(unsigned) sizeof(double) * mdim);
				break;
			default:
				break;
		}
		if(!mt[i]){
			system_mess_proc(1,"realloc_memory: m allocation failure!!!");
			stop=1;
			return;
		}
		/*
		else {
			switch(region_index){
				case 0:	data0_x[i] = mt[i]; 
					break;
				case 1: data1_x[i] = mt[i];
					break;
				case 2: data2_x[i] = mt[i];
					break;
				default:
					break;
			}
		}
		*/
	}
	return(mt);
}
