/*
### initialize the colormap for orbit plotting ###
*/
#include "../include/x11r2_kaos_def.h"
void orbit_colormap_init()
{
	extern int draw_mode;
	extern int colormap_option;
	extern int cur_color,f_color,ft_color,b_color,bt_color;
	extern int var_colormap_size,segment_count1;

	draw_mode = 0;

	switch (colormap_option) {
	case 0:
		/* standard red and blue colormap */
		b_color = Red;
		bt_color = Yellow;
		f_color = Blue;
		ft_color = Green;
		break;
	case 1:
	case 2:
		/* depth colormap - handled inside pen_mode() */
			break;
		case 3:
			/* alternating colormap: get colors in sequence
			from the predefined colormap */
			f_color = segment_count1+1; /* start from color 2 */
			(void) cycle_color(&f_color);
			ft_color = f_color;
			b_color = f_color;
			bt_color = f_color;
			break;
		case 4:
			/* use the current color but no symbols on the panel */
			f_color = cur_color;
			ft_color = f_color;
			b_color = f_color;
			bt_color = f_color;
			break;
		case 5:
			/* use the current color and symbols on the panel -
			also handled inside draw_record_orbit() */
			draw_mode = 1;

			f_color = cur_color;
			ft_color = f_color;
			b_color = f_color;
			bt_color = f_color;
			break;
		case 6:
			/* use time colormap - handled inside pen_mode() */
			break;
		case 7:
			/* Force cur_color even when redisplaying or loading 
			- handled inside all_pen_down() */
			break;
	}
}
