/*
### driver for loading data ###

Bug: Handle the case when loaded data have different dynamical system class index
*/
#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/panel.h>

void load_data_proc()
{
	int i;
	char s_key[10];
	FILE *ffp, *fopen();
	extern int big_length,new_data_format,error_result;
	extern int enable_polar,var_dim,func_dim,full_dim,param_dim;
	extern int lock_count,show_error_mess,segment_count1,segment_count0;
	extern int n_stored_data_segment1[],n_stored_data_segment0[],n_stored_data0,n_stored_data1;
	extern int region_index,save_option,save_option_old,colormap_option_old,colormap_option,model_old,model,ds_class_old,ds_class;
	extern int func_on_old,func_on,polar_section_old,polar_section,polar_coord_old,polar_coord,invert_background_old,invert_background,draw_all_old,draw_all;
	extern double *all_min,*all_max,*all_min_top,*all_max_top;
	extern double *var_min,*var_max,*var_polar_min,*var_polar_max;
	extern double *func_min,*func_max,*func_min_top,*func_max_top;
	extern char **var_polar_label,**var_label,**all_label,**func_label;
	extern char string[],full_path[],dir_name[],file_name[],lstring[],error_mess[],error_yes[],error_no[];
	extern struct init_struct { int (*init_p)();};
	extern struct init_struct init_tbl[];

	lock_count = 0;

	ds_class_old = ds_class;
	func_on_old = func_on;
	save_option_old = save_option;
	colormap_option_old = colormap_option;
	model_old = model;
	polar_section_old = polar_section;
	polar_coord_old = polar_coord;
	invert_background_old = invert_background;
	draw_all_old = draw_all;

	all_reset(); /* reset panel items */
	sprintf(full_path, "%s/%s", dir_name, file_name);	/* get path name */
	ffp = fopen(full_path, "r");	/* open a file */
	if (ffp == NULL) {
		fclose(ffp);
		sprintf(string,"File %s not found!",full_path);
		system_mess_proc(1,string);
		return;
	}

	/* get a line from a file stream */
	if (fgets(lstring, big_length, ffp) != NULL) {
		sscanf(lstring, "%s", s_key);	/* get a key in a line */

		/* Check if the file is of standard formats
		and load parameters if it is. 
		Note that load_param resets current save_option 
		and all  other parameters */
		if (strcmp(s_key, "%%T") == 0) {
			new_data_format = 0;
			if(save_option_old ==3 || save_option_old ==4 || save_option_old == 8){
				sprintf(error_mess,"This is a standard file. Read and reset window parameters,too?");
				sprintf(error_yes,"Confirm");
				sprintf(error_no,"No");
				error_result = (int) error_mess_proc(error_mess,error_yes,error_no);
				if(error_result){
					load_param(ffp);
				}
				else {
					skip_param(ffp);
				}
			}
			else {
				load_param(ffp);
			}
				
		}
		else if (strcmp(s_key, "%%TS") == 0) {
			new_data_format = 1;
			if(save_option_old ==3 || save_option_old ==4 || save_option_old == 8){
				sprintf(error_mess,"This appears to be a standard+func file. Read and reset window parameters,too?");
				sprintf(error_yes,"Confirm");
				sprintf(error_no,"No");
				error_result = (int) error_mess_proc(error_mess,error_yes,error_no);
				if(error_result){
					load_param(ffp);
				}
				else {
					skip_param(ffp);
				}
			}
			else {
				load_param(ffp);
			}

			/* check the key to see if the parameters are properly read */
			fscanf(ffp,"%s",s_key);
			if (strcmp(s_key, "%%TE") != 0) {
				system_mess_proc(1,"Header is not in the right format! Try to read as a non-standard file.");
				
				if(save_option == 1 || save_option == 6) {
					save_option = 3;
				}
				if(save_option == 2 || save_option == 7) {
					save_option = 4;
				}
				return;
			}
		}

		/* If save options for a standard format are chosen, but
		the loaded file does not have either "%%T" or "%%TS", then
		override the current selection or the loaded save_option
		and select a non-standard 2-column or full data option. */
		else if(save_option <=2 || save_option >= 5 || save_option <= 7){
			sprintf(error_mess,"This is not a standard file. Read as a non-standard file.");
			sprintf(error_yes,"2-column non-standard");
			if(region_index == 0){
				sprintf(error_no,"full (%d-d) non-standard",param_dim);
			}
			else {
				sprintf(error_no,"full (%d-d) non-standard",var_dim);
			}
			error_result = (int) error_mess_proc(error_mess,error_yes,error_no);
			if(error_result){
				save_option = 3;
			}
			else {
				save_option = 4;
			}
		}

	}

done:

	/* If either old or new save_option is set to
	window parameters only, do not load the rest of the file and exit */
	if(save_option_old ==0 || save_option_old == 5){
		fclose(ffp);
	}
	else if(save_option ==0 || save_option == 5){
		fclose(ffp);
	}
	else {
		lock();
		load_data(ffp);	/* load the main data */
		unlock();
		fclose(ffp);	/* close the file */

		/* increment segment counter and reset the number of the data
		in this segment */
		if(region_index ==1){
			segment_count1++;
			n_stored_data_segment1[segment_count1] = n_stored_data1;
		}
		else {
			segment_count0++;
			n_stored_data_segment0[segment_count0] = n_stored_data0;
		}

	}
	/* reset save_option values back to one displayed on the panel */
	save_option = save_option_old;

	reset_panels();	/* reset relevant panels */
}
