#include <suntool/sunview.h>
#include <suntool/canvas.h>

void initialize_graphics()
{
	extern Pixwin *pw;
	extern Canvas canvas;
	extern int pixel_depth,pixel_depth_entered,colormap_option,invert_background;

	/* get a pixwin on the canvas */
	pw = (Pixwin *) canvas_pixwin(canvas);
	
	/* determine a depth of a pixel from system */
	/* determine a depth of a pixel from system */
	pixel_depth = (int) get_pixel_depth();

	/* override, if necessary, with one from command line */
	if(pixel_depth_entered>0)
		pixel_depth = pixel_depth_entered;

	/* print messages and initialize */
	if(pixel_depth ==1){
		colormap_option = 0;
		invert_background = 0;
		printf("%d bit monochrome frame buffer selected!\n",pixel_depth);
	}
	else {
		colormap_option = 3;
		printf("%d bit color frame buffer selected!\n",pixel_depth);

	}

	/* load colormap */
	load_colormap(1);
	/* display colormap */
	show_colormap();	
	/* draw all the other window graphic objects */
	draw_all_objects(1);
}
