/*
### create panel for various system and graphic options ###
*/

#include <suntool/sunview.h>
#include <suntool/panel.h>
#include "../modellib/class_kaos_def.h"

void create_options_panel()
{
	int i,ipanel_row = 0,px,py;
	void options_panel_quit_proc(), colormap_option_proc(), colorcode_depth_index_proc(), invert_background_proc();
	void transient_proc(), dot_size_proc(), polar_coord_proc();
	void symbol_size_proc(),symbol_type_proc();
	extern Frame frame,options_frame,param_frame;
	extern Panel options_panel;
	extern Pixfont *boldfont;
	extern Panel_item options_panel_quit_item;
	extern Panel_item dot_size_item,transient_item, polar_coord_item, colormap_option_item;
	extern Panel_item colorcode_depth_index_item,invert_background_item, colorcode_min_item,colorcode_max_item;
	extern Panel_item symbol_type_item,symbol_size_item,cur_color_item;
	extern short options_panel_show;
	extern int panel_colormap_on;
	extern int p_l_margin, polar_coord,dot_size,show_transient,invert_background,colormap_option,colorcode_depth_index;
	extern int var_dim,cur_color,symbol_type,symbol_size;
	extern double colorcode_min,colorcode_max;
	extern char string[],**all_label,**win_var_label,**var_label,**var_polar_label;

	if(options_panel_show){
		window_set(options_frame,WIN_SHOW,TRUE,0);
		return;
	}
	else		
		options_panel_show = 1;
	px =  (int) window_get(frame,WIN_X) + (int) window_get(frame,WIN_WIDTH);
	if(px > 1152 - 200)
		px = 1152 - 200;
	py = (int) window_get(frame,WIN_Y);
	if(py > 950 - 300)
		py = 950 - 300;
	options_frame = window_create(frame, FRAME,
		FRAME_NO_CONFIRM, TRUE,
		FRAME_LABEL, "option",
		FRAME_SHOW_LABEL, TRUE,
		WIN_SHOW, TRUE,
		WIN_X, px,
		WIN_Y, py,
		WIN_FONT, boldfont,
		0);
	if(options_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		options_panel_show = 0;
		return;
	}
	options_panel = window_create(options_frame, PANEL,
		WIN_FONT, boldfont,
		0);
	if(options_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_options_panel();
		return;
	}
	options_panel_quit_item = panel_create_item(options_panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(options_panel, "Quit", 12, boldfont),
		PANEL_NOTIFY_PROC, options_panel_quit_proc,
		0);
	polar_coord_item = panel_create_item(options_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Coord System:",
		PANEL_CHOICE_STRINGS, "Primary", "Polar", 0,
		PANEL_VALUE, polar_coord,
		PANEL_NOTIFY_PROC, polar_coord_proc,
		0);
	transient_item = panel_create_item(options_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Transient:",
		PANEL_CHOICE_STRINGS, "Off", "On", 0,
		PANEL_VALUE, show_transient,
		PANEL_NOTIFY_PROC, transient_proc,
		0);
	dot_size_item = panel_create_item(options_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Dot Size:",
		PANEL_CHOICE_STRINGS, "Point", "Small","Medium","Large", "X Large","XX Large",0,
		PANEL_VALUE, dot_size,
		PANEL_NOTIFY_PROC, dot_size_proc,
		0);
	invert_background_item = panel_create_item(options_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE_DISPLAY_LENGTH, 10,
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Background:",
		PANEL_CHOICE_STRINGS, "White", "Black", 0,
		PANEL_VALUE, invert_background,
		PANEL_NOTIFY_PROC, invert_background_proc,
		0);
	colormap_option_item = panel_create_item(options_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE_DISPLAY_LENGTH, 10,
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Colormap:",
		PANEL_CHOICE_STRINGS, 
			"X11/R2",
			"Depth",
			"NL-depth",
			"Alternating",
			"Pick Color",
			"Pick Color & Symbol",
			"Time",
			"Force Current",
			"User Colormap A",
			0,
		PANEL_VALUE, colormap_option,
		PANEL_NOTIFY_PROC, colormap_option_proc,
		0);
	if(polar_coord)
		for(i=0;i<var_dim;i++) win_var_label[i] = var_polar_label[i];
	else
		for(i=0;i<var_dim;i++) win_var_label[i] = var_label[i];
	colorcode_depth_index_item = panel_create_item(options_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE_DISPLAY_LENGTH, 10,
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Colorcoding Coord:",
		PANEL_VALUE, colorcode_depth_index,
		PANEL_NOTIFY_PROC, colorcode_depth_index_proc,
		PANEL_CHOICE_STRINGS, WIN_VAR_LABELS, 0,
		0);
	sprintf(string, "%lg", colorcode_min);
	colorcode_min_item = panel_create_item(options_panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 10,
		PANEL_LABEL_STRING, "Coding Range:",
		0);
	sprintf(string, "%lg", colorcode_max);
	colorcode_max_item = panel_create_item(options_panel, PANEL_TEXT,
		PANEL_LABEL_X, ATTR_COL(25),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 10,
		PANEL_LABEL_STRING, ":",
		0);
	symbol_type_item= panel_create_item(options_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE_DISPLAY_LENGTH, 10,
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_CHOICE_STRINGS, "DOT","CROSS","TRIANG","SQUARE","XCROSS","INVTRI","DIAMON","STAR","CIRCLE","++","--","++10","--10",0,
		PANEL_LABEL_STRING, "Symbol Type:",
		PANEL_VALUE, symbol_type,
		PANEL_NOTIFY_PROC, symbol_type_proc,
		0);

	symbol_size_item = panel_create_item(options_panel,PANEL_CYCLE,
		PANEL_LABEL_X,  ATTR_COL(25),
		PANEL_DISPLAY_LEVEL,    PANEL_CURRENT,
		PANEL_LABEL_STRING,     "Symbol Size:",
		PANEL_CHOICE_STRINGS,   "X Sm","Sm","Sm-Med","Med","Med-Lg","Lg","X Lg",0,
		PANEL_VALUE,symbol_size,
		PANEL_NOTIFY_PROC, symbol_size_proc,
		0);
	sprintf(string, "%d", cur_color);
	cur_color_item= panel_create_item(options_panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 10,
		PANEL_LABEL_STRING, "Current Color:",
		0);
	window_fit(options_panel);
	window_fit(options_frame);

	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(options_panel,WIN_PIXWIN),"options_cms");
}
