/*
### create a help window ###
*/

#define QUERY_LIST \
"Equation",
"System Parameters",
"Special Orbits",
"Special Orbits,Eigenvalues,Eigenvectors",
"Manifolds",
"Time Series",
"Fourier Amplitudes",
"Lyapunov Exponents",
"Dimension Fit",
"Scan-List"

#include <suntool/sunview.h>
#include <suntool/textsw.h>
#include <suntool/panel.h>

void create_query_windows()
{
	void query_quit_proc(),query_option_proc();
	int i,ipanel_row=0,px,py;
	extern Frame frame,query_frame;
	extern Panel query_panel;
	extern Textsw query_textsw;
	extern Textsw_status query_status; 
	extern Pixfont *boldfont;
	extern Panel_item query_quit_item,query_option_item;
	extern short query_panel_show;
	extern int panel_colormap_on;
	extern int query_option;
	extern char string[],query_dir[];
	
	/* Turn on the flag */	
	if(query_panel_show){
		window_set(query_frame,WIN_SHOW,TRUE,0);	
		return;
	}
	else
		query_panel_show = 1;

	px = (int) window_get(frame,WIN_X) + (int) window_get(frame,WIN_WIDTH)/2;
	py = (int) window_get(frame,WIN_Y) + (int) window_get(frame,WIN_HEIGHT) /2;
	/* Create help frame */
	query_frame = window_create(frame,FRAME,
		FRAME_NO_CONFIRM,       TRUE,
		FRAME_LABEL,    "help",
		FRAME_SHOW_LABEL,       TRUE,
		WIN_SHOW,       TRUE,
		WIN_X,  px,
		WIN_Y,  py,
		WIN_HEIGHT, 400,
		WIN_WIDTH, 650,
		WIN_FONT, boldfont,
		0);
	if(query_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		query_panel_show = 0;
		return;
	}
	/* Create Panel */
	query_panel = window_create(query_frame, PANEL,
		WIN_X, 0,
		WIN_Y, 0,
		WIN_FONT, boldfont,
		0);
	if(query_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_query_windows();
		return;
	}
	/* Create panel items */
	query_quit_item= panel_create_item(query_panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(query_panel, "Quit", 4, boldfont),
		PANEL_NOTIFY_PROC, query_quit_proc,
		0);
	query_option_item= panel_create_item(query_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Topic: ",
		PANEL_CHOICE_STRINGS,
			QUERY_LIST,
			0,
		PANEL_VALUE, query_option,
		PANEL_NOTIFY_PROC, query_option_proc,
		0);

	window_fit_height(query_panel);

	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(query_panel,WIN_PIXWIN),"query_panel_cms");

        sprintf(string,"%s/online_help.0",query_dir);
        query_textsw = window_create(query_frame, TEXTSW,
		0);
	if(query_textsw == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_query_windows();
		return;
	}
	window_set(query_textsw,
                TEXTSW_STATUS, &query_status,
                TEXTSW_FILE,string,
                TEXTSW_FIRST,0,
                0);
        if(query_status == TEXTSW_STATUS_CANNOT_OPEN_INPUT){
                sprintf(string,"Help file (%s/%d) does not exist!\n",query_dir,query_option);
                system_mess_proc(1,string);
        }       
	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(query_textsw,WIN_PIXWIN),"query_textsw_cms");
}
