int vanderpol_init()
{
	title_label = "Van der Pol's Eq";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;

	var_dim = 2;
	param_dim = 3;
	func_dim = 2;

	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	param_label[0] = "alpha";
	param_label[1] = "beta";
	param_label[2] = "omega";
	func_label[0] = "t";
	func_label[1] = "Undefined";

	param[0] = 1;
	param[1] = 0;
	param[2] = 1;

	var_i[0] = 0;
	var_i[1] = 0;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;
	param_min[2]= 0; param_max[2]= 5;

	var_min[0]= -5; var_max[0]= 5;
	var_min[1]= -5; var_max[1]= 5;

	f_p = vanderpol_f;
	func_p = vanderpol_func;
}
/* Van der Pol's equation */
int vanderpol_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double cos();
	f[0] = x[1] - p[0]*(x[0]*x[0]*x[0]/3. - x[0]);
	f[1] = -x[0] + p[1]*cos(p[2]*t);
}
int vanderpol_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	f[0] = t;
	f[1] = 0;
}
