/*
### allocate memory dynamically after selecting or loading a new model ###
*/

#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>

void malloc_aux_init()
{
	int *ivector(),**imatrix();
	extern int batch_on,func_on,var_dim,full_dim,func_dim,param_dim,aux_max;
	extern int *aux_on,*aux_win_mode,*aux_rescale,**aux_cur_index;
	extern Frame *aux_frame;
	extern Canvas *aux_canvas;
	extern Cursor *aux_cursor;
	extern Panel *aux_panel;
	extern Pixwin **aux_pw;
	extern Panel_item *aux_quit_item,*aux_copy_item,*aux_win_mode_item,*aux_x_item,*aux_y_item,*aux_x_min_item,*aux_x_max_item,*aux_y_min_item,*aux_y_max_item;

	aux_win_mode = ivector(0,aux_max-1);
	aux_on = ivector(0,aux_max-1);
	aux_rescale = ivector(0,aux_max-1);
	aux_cur_index = imatrix(0,aux_max-1,0,1);
	
	if(!batch_on){
		/* aux windows */
		aux_frame = (Frame *) malloc((unsigned) sizeof(Frame) * aux_max);
		aux_canvas = (Canvas *) malloc((unsigned) sizeof(Canvas) * aux_max);
		aux_cursor = (Cursor *) malloc((unsigned) sizeof(Cursor) * aux_max);
		aux_panel = (Panel *) malloc((unsigned) sizeof(Panel) * aux_max);
		aux_pw = (Pixwin **) malloc((unsigned) sizeof(Pixwin *) * aux_max);
		aux_quit_item = (Panel_item *) malloc((unsigned) sizeof(Panel_item) * aux_max);
		aux_win_mode_item = (Panel_item *) malloc((unsigned) sizeof(Panel_item) * aux_max);
		aux_copy_item = (Panel_item *) malloc((unsigned) sizeof(Panel_item) * aux_max);
		aux_x_item = (Panel_item *) malloc((unsigned) sizeof(Panel_item) * aux_max);
		aux_y_item = (Panel_item *) malloc((unsigned) sizeof(Panel_item) * aux_max);
		aux_x_min_item = (Panel_item *) malloc((unsigned) sizeof(Panel_item) * aux_max);
		aux_x_max_item = (Panel_item *) malloc((unsigned) sizeof(Panel_item) * aux_max);
		aux_y_min_item = (Panel_item *) malloc((unsigned) sizeof(Panel_item) * aux_max);
		aux_y_max_item = (Panel_item *) malloc((unsigned) sizeof(Panel_item) * aux_max);
	}
}
