
int jjarray_init()
{
	title_label = "Josephson Junction- Resistive Load";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 1;

	var_dim = 6;
	param_dim = 2;
	func_dim = 2;

	(void) malloc_init();

	period_len[0] = twopi;
	period_len[2] = twopi;
	period_len[4] = twopi;
	var_label[0] = "phi1";
	var_label[1] = "psi1";
	var_label[2] = "phi2";
	var_label[3] = "psi2";
	var_label[4] = "phi3";
	var_label[5] = "psi3";
	param_label[0] = "IB";
	param_label[1] = "beta";
	func_label[0] = "t";
	func_label[1] = "Load";

	param[0] = 1.2;
	param[1] = 1.6;

	var_i[0] = 0.3;
	var_i[1] = 0.2;
	var_i[2] = 0.324;
	var_i[3] = 0.12;
	var_i[4] = 0.41;
	var_i[5] = 0;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;

	var_min[0]= 0; var_max[0]= twopi;
	var_min[1]= -.5; var_max[1]=2.5;
	var_min[2]= 0; var_max[2]= twopi;
	var_min[3]= -.5; var_max[3]=2.5;
	var_min[4]= 0; var_max[4]= twopi;
	var_min[5]= -.5; var_max[5]=2.5;
	func_min[0]= -5; func_max[0]= 5;
	func_min[1]= -3; func_max[0]= 6;

	f_p = jjarray_f;
	func_p = jjarray_func;
}

int jjarray_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	int i;
	double ib,beta,q;
	ib = p[0];
	beta = p[1];
	q = 0;
	for(i=1;i<dim;i += 2)
		q += x[i];
	f[0] = x[1];
	f[1] = (ib - x[1] - sin(x[0]) - 2. / dim * q ) /beta;
	f[2] = x[3];
	f[3] = (ib - x[3] - sin(x[2]) - 2. / dim * q ) /beta;
	f[4] = x[5];
	f[5] = (ib - x[5] - sin(x[4]) - 2. / dim * q ) /beta;
}
int jjarray_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	int i;

	f[0] = t;
	f[1] = 0;
	for(i=1;i<dim;i += 2)
		f[1] += x[i];
}
