int dissstandmap_init()
{
	title_label = "(Dissipative) Standard Map";
	mapping_on = 1;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 1;
	var_dim = 2;
	param_dim = 3;
	func_dim = 2;

	(void) malloc_init();

	period_len[0] = 1;
	period_len[1] = 0;
	
	var_label[0] = "x";
	var_label[1] = "r";
	param_label[0] = "w";
	param_label[1] = "k";
	param_label[2] = "b";
	func_label[0] = "Rhox";
	func_label[1] = "Undefined";

	param[0] = 0;
	param[1] = 0.97;
	param[2] = 1;
	var_i[0] = .5;
	var_i[1] = .5;

	param_min[0]= 0; param_max[0]= 1;
	param_min[1]= 0; param_max[1]= 1;
	param_min[2]= 0; param_max[2]= 1;
	var_min[0]= 0; var_max[0]= 1;
	var_min[1]= 0; var_max[1]= 1;
	func_min[0]= 0; func_max[0]= 1;

	f_p = dissstandmap_f;
	func_p = dissstandmap_func;
}
/* Diss. Standard Map */
int dissstandmap_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double v0sq,v1sq,v2sq,v3sq;

	/* forward map */
	if(index ==1) {
		f[1] = p[2] * x[1] - p[1] / twopi * sin(twopi * x[0]);
		f[0] = x[0] + p[0] + f[1];
	}
	/* backward map */
	else if(index ==0) {
		f[0] = x[0] - p[0] -x[1];
		f[1] = (x[1] + p[1]/twopi * sin(twopi * f[0]))/p[2];
	}
	
}
int dissstandmap_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	int i;
	extern int forward_toggle;
	extern double *v;
	extern int (*f_p)();
	
	(int) f_p(v,forward_toggle,x,p,t,dim);
	f[0] = v[0]-x[0];
}
