/*
		### batch driver program for kaos ### 
*****************************************************************************

	Swan Kim and John Guckenheimer, POSTECH & Cornell U, 11/1/89
			
*****************************************************************************
*/

#include "include/kaos.h"

main(argc,argv)
int argc;
char **argv;
{
	int i;
	int batch_count;
	char s_key[10];
	
	/* region_index needs to be passed from the main program */
	region_index = 1;

	batch_on = 1;
	symbol_type = 0;
	int_driver = 0;
	batch_count = 4;
	mapping_on = 0;
	inverse_on =0;
	cur_color = 1;
	f_color = 1;
	continue_toggle = 0;
	forward_toggle = 1;
	my_colormap_size = 128;
	var_colormap_size = 50;
	segment_count1 = 3;
	sprintf(dir_name,"/mnt/kim/kaos");
	sprintf(file_name,"tmp.dat");
	
	for (i=1; i<argc; i++){
		if (strcmp(argv[i],"-s") == 0) {
			i++;
			symbol_type = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-i") == 0) {
			i++;
			int_driver = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-mo") == 0) {
			i++;
			mapping_on = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-io") == 0) {
			i++;
			inverse_on = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-b") == 0) {
			i++;
			batch_count = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-c") == 0) {
			i++;
			continue_toggle = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-f") == 0) {
			i++;
			forward_toggle = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-cc") == 0) {
			i++;
			cur_color= atoi(argv[i]);
		}
		if (strcmp(argv[i],"-fc") == 0) {
			i++;
			f_color = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-mc") == 0) {
			i++;
			my_colormap_size = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-vc") == 0) {
			i++;
			var_colormap_size = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-n") == 0) {
			i++;
			segment_count1= atoi(argv[i]);
		}
		if (strcmp(argv[i],"-D") == 0) {
			i++;
			sprintf(dir_name,"%s",argv[i]);
		}
		if (strcmp(argv[i],"-F") == 0) {
			i++;
			sprintf(file_name,"%s",argv[i]);
		}
	}
	
	(void) model_init();

	/* read the parameters from a temorary file written by a main program */
	sprintf(full_path,"%s/batch.inp%d",dir_name,batch_count);
	ffp = fopen(full_path,"r");
	if(ffp == NULL){
		fclose(ffp);
		return;
	}

	if(fgets(lstring,big_length,ffp) != NULL){
		sscanf(lstring,"%s",s_key);
		if(strcmp(s_key,"%%T") ==0){
			new_data_format = 0;
			load_param(ffp);
		}
		else if(strcmp(s_key,"%%TS") == 0){
			system_mess_proc(0,"Batch: Corrent starting header!");
			new_data_format = 1;
			load_param(ffp);
			fscanf(ffp,"%s",s_key);
			if(strcmp(s_key,"%%TE") ==0){
				system_mess_proc(0,"Batch: Correct ending header!");
			}
			else {
				fclose(ffp);
				sprintf(string,"Batch: Incorrent ending header ((%s))!",s_key);
				system_mess_proc(0,string);
				return;
			}
		}
		else {
			sprintf(string,"Batch: Nonstandard header (%s)!",s_key);
			system_mess_proc(0,string);
		}
	}
	fclose(ffp);
	
	system_mess_proc(0,"Batch: Read all parameters from a tempoaray file!");
	sprintf(full_path,"%s/batch.tmp%d.%s",dir_name,batch_count,file_name);
	ffp = fopen(full_path,"w");

	(void) orbit_colormap_init();
	
	if(!continue_toggle){
		from_window_variables(t_v,win_var_i,polar_coord);
		(void) get_func(func_i,win_var_i,param,time,polar_coord);
	}
	
	/* two routines for map and ode, respectively */
	if(mapping_on){
		if (forward_toggle == 1){
			i_stop = (int) map_forward();
		}
		else {
			if(inverse_on){
				i_stop = (int) map_forward();
			}
			else {
				i_stop = (int) map_implicit_backward();
			}
		}
	}
	else {
		if(int_driver == 0 || int_driver == 1){ 
			if (forward_toggle == 1){
				i_stop = (int) ode_forward();
			}
			else {
				time_step = -time_step;
				i_stop = (int) ode_forward();
				time_step = -time_step;
			}
		}
		else if(int_driver == 2){
			if (forward_toggle == 1){
				i_stop = (int) ode_qc_forward();
			}
			else {
				time_step = -time_step;
				i_stop = (int) ode_qc_forward();
				time_step = -time_step;
			}
		}
	}

	from_window_variables(t_v,win_var_f,polar_coord);
	(void) get_func(func_f,t_v,param,time,var_dim);
	if (section_count == 0)
		average_return_time = -999;
	else
		average_return_time = time_step * i_stop / (double) section_count;
	average_return_time = time_step * i_stop / (double) section_count;
	fclose(ffp);
	
	sprintf(full_path,"%s/%s",dir_name,file_name);
	ffp = fopen(full_path,"w");
	/* save the key header */
	if(new_data_format==1){
		fprintf(ffp, "%%%%TS\n");
	}
	else if(new_data_format==0){
		fprintf(ffp, "%%%%T\n");
	}
	save_param(ffp);
	if(new_data_format==1){
		fprintf(ffp, "%%%%TE\n");
	}
	else {
	}

	fclose(ffp);
	sprintf(lstring,"cat %s/batch.tmp%d.%s >> %s/%s; rm -f %s/batch.tmp%d.%s",dir_name,batch_count,file_name,dir_name,file_name,dir_name,batch_count,file_name);
	system(lstring);
}
